/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexResilience;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexCurrency;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.service.BittrexAccountService;
import org.knowm.xchange.bittrex.service.BittrexMarketDataService;
import org.knowm.xchange.bittrex.service.BittrexMarketDataServiceRaw;
import org.knowm.xchange.bittrex.service.BittrexTradeService;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.nonce.AtomicLongIncrementalTime2013NonceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BittrexExchange
extends BaseExchange
implements Exchange {
    private final SynchronizedValueFactory<Long> nonceFactory = new AtomicLongIncrementalTime2013NonceFactory();
    private static final Object INIT_LOCK = new Object();
    private static final Logger EXCHANGE_LOGGER = LoggerFactory.getLogger(BittrexExchange.class);
    private static List<BittrexSymbol> bittrexSymbols = new ArrayList<BittrexSymbol>();
    private static ResilienceRegistries resilienceRegistries;

    protected void initServices() {
        BittrexAuthenticated bittrex = (BittrexAuthenticated)ExchangeRestProxyBuilder.forInterface(BittrexAuthenticated.class, (ExchangeSpecification)this.getExchangeSpecification()).build();
        this.marketDataService = new BittrexMarketDataService(this, bittrex, this.getResilienceRegistries());
        this.accountService = new BittrexAccountService(this, bittrex, this.getResilienceRegistries());
        this.tradeService = new BittrexTradeService(this, bittrex, this.getResilienceRegistries());
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://api.bittrex.com/");
        exchangeSpecification.setHost("bittrex.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Bittrex");
        exchangeSpecification.setExchangeDescription("Bittrex is a cryptocurrencies exchange.");
        return exchangeSpecification;
    }

    public synchronized ResilienceRegistries getResilienceRegistries() {
        if (resilienceRegistries == null) {
            resilienceRegistries = BittrexResilience.createRegistries();
        }
        return resilienceRegistries;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteInit() throws IOException {
        if (bittrexSymbols.isEmpty()) {
            Object object = INIT_LOCK;
            synchronized (object) {
                if (bittrexSymbols.isEmpty()) {
                    bittrexSymbols = ((BittrexMarketDataServiceRaw)this.marketDataService).getBittrexSymbols();
                    List<BittrexCurrency> bittrexCurrencies = ((BittrexMarketDataServiceRaw)this.marketDataService).getBittrexCurrencies();
                    Map dynamicTradingFees = null;
                    try {
                        dynamicTradingFees = this.accountService.getDynamicTradingFees();
                    }
                    catch (IOException | BittrexException | ExchangeException e) {
                        EXCHANGE_LOGGER.warn("Error during remote init, can not fetch trading fees. May be missing auth tokens ?", (Throwable)e);
                    }
                    BittrexAdapters.adaptMetaData(bittrexSymbols, bittrexCurrencies, dynamicTradingFees, this.exchangeMetaData);
                }
            }
        }
    }
}

