/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.exceptions.CurrencyPairNotValidException;
import org.knowm.xchange.exceptions.ExchangeException;

public class BittrexErrorAdapter {
    public static ExchangeException adapt(BittrexException e) {
        String code = e.getCode();
        if (StringUtils.isEmpty((CharSequence)code)) {
            return new ExchangeException("Operation failed without any error code", (Throwable)((Object)e));
        }
        switch (code) {
            case "MARKET_DOES_NOT_EXIST": {
                return new CurrencyPairNotValidException((Throwable)((Object)e));
            }
        }
        String message = e.getDetails();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = "Operation failed with error code: " + code;
        }
        return new ExchangeException(message, (Throwable)((Object)e));
    }
}

