/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bittrex.Bittrex;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.account.BittrexAccountVolume;
import org.knowm.xchange.bittrex.dto.account.BittrexAddress;
import org.knowm.xchange.bittrex.dto.account.BittrexBalance;
import org.knowm.xchange.bittrex.dto.account.BittrexBalances;
import org.knowm.xchange.bittrex.dto.account.BittrexComissionRatesWithMarket;
import org.knowm.xchange.bittrex.dto.account.BittrexDepositHistory;
import org.knowm.xchange.bittrex.dto.account.BittrexNewAddress;
import org.knowm.xchange.bittrex.dto.account.BittrexWithdrawalHistory;
import org.knowm.xchange.bittrex.dto.batch.BatchResponse;
import org.knowm.xchange.bittrex.dto.batch.order.BatchOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexNewOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrders;
import org.knowm.xchange.bittrex.dto.withdrawal.BittrexNewWithdrawal;
import org.knowm.xchange.bittrex.dto.withdrawal.BittrexWithdrawal;
import si.mazi.rescu.ParamsDigest;

@Path(value="v3")
@Produces(value={"application/json"})
public interface BittrexAuthenticated
extends Bittrex {
    @GET
    @Path(value="account/fees/trading")
    public List<BittrexComissionRatesWithMarket> getTradingFees(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4) throws IOException, BittrexException;

    @GET
    @Path(value="account/volume")
    public BittrexAccountVolume getAccountVolume(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4) throws IOException, BittrexException;

    @POST
    @Path(value="batch")
    @Consumes(value={"application/json"})
    public BatchResponse[] executeOrdersBatch(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, BatchOrder[] var5) throws IOException, BittrexException;

    @DELETE
    @Path(value="orders/{order_id}")
    public BittrexOrder cancelOrder(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, @PathParam(value="order_id") String var5) throws IOException, BittrexException;

    @GET
    @Path(value="balances")
    public BittrexBalances getBalances(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4) throws IOException, BittrexException;

    @GET
    @Path(value="balances/{currencySymbol}")
    public BittrexBalance getBalance(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, @PathParam(value="currencySymbol") String var5) throws IOException, BittrexException;

    @GET
    @Path(value="addresses")
    public List<BittrexAddress> getAddresses(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4) throws IOException, BittrexException;

    @GET
    @Path(value="addresses/{currencySymbol}")
    public BittrexAddress getAddress(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, @PathParam(value="currencySymbol") String var5) throws IOException, BittrexException;

    @POST
    @Path(value="addresses")
    public BittrexAddress generateAddress(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, BittrexNewAddress var5) throws IOException, BittrexException;

    @GET
    @Path(value="orders/{orderId}")
    public BittrexOrder getOrder(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, @PathParam(value="orderId") String var5) throws IOException, BittrexException;

    @POST
    @Path(value="orders")
    @Consumes(value={"application/json"})
    public BittrexOrder placeOrder(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, BittrexNewOrder var5) throws IOException, BittrexException;

    @GET
    @Path(value="orders/open")
    public BittrexOrders getOpenOrders(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4) throws IOException, BittrexException;

    @GET
    @Path(value="orders/closed")
    public List<BittrexOrder> getClosedOrders(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, @QueryParam(value="marketSymbol") String var5, @QueryParam(value="pageSize") Integer var6, @QueryParam(value="startDate") Date var7, @QueryParam(value="endDate") Date var8) throws IOException, BittrexException;

    @GET
    @Path(value="deposits/closed")
    public List<BittrexDepositHistory> getDepositsClosed(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, @QueryParam(value="currencySymbol") String var5, @QueryParam(value="nextPageToken") String var6, @QueryParam(value="previousPageToken") String var7, @QueryParam(value="pageSize") Integer var8) throws IOException, BittrexException;

    @GET
    @Path(value="withdrawals/closed")
    public List<BittrexWithdrawalHistory> getWithdrawalsClosed(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, @QueryParam(value="currencySymbol") String var5, @QueryParam(value="nextPageToken") String var6, @QueryParam(value="previousPageToken") String var7, @QueryParam(value="pageSize") Integer var8) throws IOException, BittrexException;

    @POST
    @Path(value="withdrawals")
    @Consumes(value={"application/json"})
    public BittrexWithdrawal createNewWithdrawal(@HeaderParam(value="Api-Key") String var1, @HeaderParam(value="Api-Timestamp") Long var2, @HeaderParam(value="Api-Content-Hash") ParamsDigest var3, @HeaderParam(value="Api-Signature") ParamsDigest var4, BittrexNewWithdrawal var5) throws IOException, BittrexException;
}

