/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.account.BittrexBalance;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexCurrency;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexLevel;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexMarketSummary;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTicker;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.WalletHealth;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.instrument.Instrument;

public final class BittrexAdapters {
    public static List<CurrencyPair> adaptCurrencyPairs(Collection<BittrexSymbol> bittrexSymbols) {
        return bittrexSymbols.stream().map(BittrexAdapters::adaptCurrencyPair).collect(Collectors.toList());
    }

    public static CurrencyPair adaptCurrencyPair(BittrexSymbol bittrexSymbol) {
        Currency baseSymbol = bittrexSymbol.getBaseCurrencySymbol();
        Currency counterSymbol = bittrexSymbol.getQuoteCurrencySymbol();
        return new CurrencyPair(baseSymbol, counterSymbol);
    }

    public static List<LimitOrder> adaptOpenOrders(List<BittrexOrder> bittrexOpenOrders) {
        return bittrexOpenOrders == null ? null : bittrexOpenOrders.stream().map(BittrexAdapters::adaptOrder).collect(Collectors.toList());
    }

    public static List<LimitOrder> adaptOrders(BittrexLevel[] orders, CurrencyPair currencyPair, Order.OrderType orderType, int depth) {
        if (orders == null || orders.length == 0) {
            return new ArrayList<LimitOrder>();
        }
        return Arrays.stream(orders).limit(Math.min(orders.length, depth)).map(order -> new LimitOrder.Builder(orderType, (Instrument)currencyPair).originalAmount(order.getAmount()).limitPrice(order.getPrice()).build()).collect(Collectors.toList());
    }

    public static LimitOrder adaptOrder(BittrexOrder order) {
        return BittrexAdapters.adaptOrder(order, BittrexAdapters.adaptOrderStatus(order));
    }

    public static LimitOrder adaptOrder(BittrexOrder order, Order.OrderStatus status) {
        Order.OrderType type = order.getDirection().equalsIgnoreCase("SELL") ? Order.OrderType.ASK : Order.OrderType.BID;
        CurrencyPair pair = BittrexUtils.toCurrencyPair(order.getMarketSymbol());
        return new LimitOrder.Builder(type, (Instrument)pair).originalAmount(order.getQuantity()).id(order.getId()).timestamp(order.getUpdatedAt() != null ? order.getUpdatedAt() : order.getCreatedAt()).limitPrice(order.getLimit()).remainingAmount(order.getQuantity().subtract(order.getFillQuantity())).fee(order.getCommission()).orderStatus(status).build();
    }

    public static Order.OrderStatus adaptOrderStatus(BittrexOrder order) {
        if (order.getClosedAt() != null) {
            return Order.OrderStatus.CLOSED;
        }
        if (order.getQuantity() == null) {
            return Order.OrderStatus.UNKNOWN;
        }
        if (order.getFillQuantity() == null || order.getFillQuantity().compareTo(BigDecimal.ZERO) == 0) {
            return Order.OrderStatus.NEW;
        }
        BigDecimal remaining = order.getQuantity().subtract(order.getFillQuantity());
        return remaining.signum() == 1 ? Order.OrderStatus.PARTIALLY_FILLED : Order.OrderStatus.FILLED;
    }

    public static Trade adaptTrade(BittrexTrade trade, CurrencyPair currencyPair) {
        Order.OrderType orderType = "BUY".equalsIgnoreCase(trade.getTakerSide()) ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = trade.getQuantity();
        BigDecimal price = trade.getRate();
        Date date = trade.getExecutedAt();
        String tradeId = trade.getId();
        return new Trade.Builder().type(orderType).originalAmount(amount).currencyPair(currencyPair).price(price).timestamp(date).id(tradeId).build();
    }

    public static Trades adaptTrades(List<BittrexTrade> trades, CurrencyPair currencyPair) {
        return new Trades(trades.stream().map(trade -> BittrexAdapters.adaptTrade(trade, currencyPair)).sorted(Comparator.comparing(Trade::getTimestamp)).collect(Collectors.toList()), Trades.TradeSortType.SortByTimestamp);
    }

    public static List<UserTrade> adaptUserTrades(List<BittrexOrder> bittrexUserTrades) {
        return bittrexUserTrades.stream().map(bittrexOrder -> new UserTrade.Builder().type("BUY".equalsIgnoreCase(bittrexOrder.getDirection()) ? Order.OrderType.BID : Order.OrderType.ASK).originalAmount(bittrexOrder.getFillQuantity()).currencyPair(BittrexUtils.toCurrencyPair(bittrexOrder.getMarketSymbol())).price(bittrexOrder.getLimit()).timestamp(bittrexOrder.getClosedAt()).id(bittrexOrder.getId()).feeAmount(bittrexOrder.getCommission()).feeCurrency(BittrexUtils.toCurrencyPair((String)bittrexOrder.getMarketSymbol()).counter).build()).collect(Collectors.toList());
    }

    public static List<Ticker> adaptTickers(Set<CurrencyPair> currencyPairs, List<BittrexMarketSummary> bittrexMarketSummaries, List<BittrexTicker> bittrexTickers) {
        HashMap tickerCombinationMap = new HashMap(Math.min(bittrexMarketSummaries.size(), bittrexTickers.size()));
        bittrexMarketSummaries.forEach(marketSummary -> tickerCombinationMap.put(BittrexUtils.toCurrencyPair(marketSummary.getSymbol()), new SummaryTickerPair((BittrexMarketSummary)marketSummary, null)));
        bittrexTickers.forEach(ticker -> {
            CurrencyPair currencyPair = BittrexUtils.toCurrencyPair(ticker.getSymbol());
            if (tickerCombinationMap.containsKey(currencyPair)) {
                ((SummaryTickerPair)tickerCombinationMap.get(currencyPair)).setTicker((BittrexTicker)ticker);
            }
        });
        return tickerCombinationMap.entrySet().stream().filter(entry -> currencyPairs.isEmpty() || currencyPairs.contains(entry.getKey())).map(Map.Entry::getValue).filter(summaryTickerPair -> summaryTickerPair.getSummary() != null && summaryTickerPair.getTicker() != null).map(summaryTickerPair -> BittrexAdapters.adaptTicker(summaryTickerPair.getSummary(), summaryTickerPair.getTicker())).collect(Collectors.toList());
    }

    public static Ticker adaptTicker(BittrexMarketSummary bittrexMarketSummary, BittrexTicker bittrexTicker) {
        CurrencyPair currencyPair = BittrexUtils.toCurrencyPair(bittrexTicker.getSymbol());
        BigDecimal last = bittrexTicker.getLastTradeRate();
        BigDecimal bid = bittrexTicker.getBidRate();
        BigDecimal ask = bittrexTicker.getAskRate();
        BigDecimal high = bittrexMarketSummary.getHigh();
        BigDecimal low = bittrexMarketSummary.getLow();
        BigDecimal quoteVolume = bittrexMarketSummary.getQuoteVolume();
        BigDecimal volume = bittrexMarketSummary.getVolume();
        BigDecimal percentageChange = bittrexMarketSummary.getPercentChange();
        Date timestamp = bittrexMarketSummary.getUpdatedAt();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).quoteVolume(quoteVolume).volume(volume).percentageChange(percentageChange).timestamp(timestamp).build();
    }

    public static Wallet adaptWallet(Collection<BittrexBalance> balances) {
        List wallets = balances.stream().map(bittrexBalance -> new Balance.Builder().currency(bittrexBalance.getCurrencySymbol()).total(bittrexBalance.getTotal()).available(bittrexBalance.getAvailable()).timestamp(bittrexBalance.getUpdatedAt()).build()).collect(Collectors.toList());
        return Wallet.Builder.from(wallets).build();
    }

    public static void adaptMetaData(List<BittrexSymbol> rawSymbols, List<BittrexCurrency> bittrexCurrencies, Map<CurrencyPair, Fee> dynamicTradingFees, ExchangeMetaData metaData) {
        List<CurrencyPair> currencyPairs = BittrexAdapters.adaptCurrencyPairs(rawSymbols);
        for (CurrencyPair currencyPair : currencyPairs) {
            CurrencyPairMetaData defaultCurrencyPairMetaData = (CurrencyPairMetaData)metaData.getCurrencyPairs().get(currencyPair);
            BigDecimal resultingFee = null;
            if (dynamicTradingFees != null) {
                Fee fee = dynamicTradingFees.get(currencyPair);
                if (fee != null) {
                    resultingFee = fee.getMakerFee();
                }
            } else if (defaultCurrencyPairMetaData != null) {
                resultingFee = defaultCurrencyPairMetaData.getTradingFee();
            }
            CurrencyPairMetaData newCurrencyPairMetaData = defaultCurrencyPairMetaData != null ? new CurrencyPairMetaData(resultingFee, defaultCurrencyPairMetaData.getMinimumAmount(), defaultCurrencyPairMetaData.getMaximumAmount(), defaultCurrencyPairMetaData.getPriceScale(), defaultCurrencyPairMetaData.getVolumeScale(), defaultCurrencyPairMetaData.getFeeTiers(), defaultCurrencyPairMetaData.getTradingFeeCurrency()) : new CurrencyPairMetaData(resultingFee, null, null, null, null, null, null);
            metaData.getCurrencyPairs().put(currencyPair, newCurrencyPairMetaData);
        }
        for (BittrexCurrency bittrexCurrency : bittrexCurrencies) {
            WalletHealth walletHealth = WalletHealth.UNKNOWN;
            if ("ONLINE".equals(bittrexCurrency.getStatus())) {
                walletHealth = WalletHealth.ONLINE;
            } else if ("OFFLINE".equals(bittrexCurrency.getStatus())) {
                walletHealth = WalletHealth.OFFLINE;
            }
            metaData.getCurrencies().put(bittrexCurrency.getSymbol(), new CurrencyMetaData(Integer.valueOf(1), BigDecimal.valueOf(bittrexCurrency.getTxFee()), null, walletHealth));
        }
    }

    private BittrexAdapters() {
        throw new AssertionError();
    }

    private static class SummaryTickerPair {
        private BittrexMarketSummary summary;
        private BittrexTicker ticker;

        public BittrexMarketSummary getSummary() {
            return this.summary;
        }

        public BittrexTicker getTicker() {
            return this.ticker;
        }

        public void setSummary(BittrexMarketSummary summary) {
            this.summary = summary;
        }

        public void setTicker(BittrexTicker ticker) {
            this.ticker = ticker;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SummaryTickerPair)) {
                return false;
            }
            SummaryTickerPair other = (SummaryTickerPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BittrexMarketSummary this$summary = this.getSummary();
            BittrexMarketSummary other$summary = other.getSummary();
            if (this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary)) {
                return false;
            }
            BittrexTicker this$ticker = this.getTicker();
            BittrexTicker other$ticker = other.getTicker();
            return !(this$ticker == null ? other$ticker != null : !((Object)this$ticker).equals(other$ticker));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SummaryTickerPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BittrexMarketSummary $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
            BittrexTicker $ticker = this.getTicker();
            result = result * 59 + ($ticker == null ? 43 : ((Object)$ticker).hashCode());
            return result;
        }

        public String toString() {
            return "BittrexAdapters.SummaryTickerPair(summary=" + this.getSummary() + ", ticker=" + this.getTicker() + ")";
        }

        public SummaryTickerPair(BittrexMarketSummary summary, BittrexTicker ticker) {
            this.summary = summary;
            this.ticker = ticker;
        }
    }
}

