/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import java.io.IOException;
import javax.annotation.Nullable;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.BitstampV2;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampOrderBook;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampPairInfo;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTicker;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTransaction;
import org.knowm.xchange.bitstamp.service.BitstampBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactory;

public class BitstampMarketDataServiceRaw
extends BitstampBaseService {
    private final BitstampV2 bitstampV2;

    public BitstampMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitstampV2 = (BitstampV2)RestProxyFactory.createProxy(BitstampV2.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
    }

    public BitstampTicker getBitstampTicker(CurrencyPair pair) throws IOException {
        try {
            return this.bitstampV2.getTicker(new BitstampV2.Pair(pair));
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampTicker getBitstampTickerHourly(CurrencyPair pair) throws IOException {
        try {
            return this.bitstampV2.getTickerHour(new BitstampV2.Pair(pair));
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampOrderBook getBitstampOrderBook(CurrencyPair pair) throws IOException {
        try {
            return this.bitstampV2.getOrderBook(new BitstampV2.Pair(pair));
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampTransaction[] getTransactions(CurrencyPair pair, @Nullable BitstampTime time) throws IOException {
        try {
            return this.bitstampV2.getTransactions(new BitstampV2.Pair(pair), time);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampPairInfo[] getTradingPairsInfo() throws IOException {
        try {
            return this.bitstampV2.getTradingPairsInfo();
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public static enum BitstampTime {
        DAY,
        HOUR,
        MINUTE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

