/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FundsExceededException;
import org.knowm.xchange.exceptions.InternalServerException;
import org.knowm.xchange.exceptions.NonceException;
import org.knowm.xchange.exceptions.RateLimitExceededException;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;

public class BitstampBaseService
extends BaseExchangeService
implements BaseService {
    public BitstampBaseService(Exchange exchange) {
        super(exchange);
    }

    protected ExchangeException handleError(BitstampException exception) {
        if (exception.getMessage().contains("You can only buy")) {
            return new FundsExceededException((Throwable)((Object)exception));
        }
        if (exception.getMessage().contains("Invalid limit exceeded")) {
            return new RateLimitExceededException((Throwable)((Object)exception));
        }
        if (exception.getMessage().contains("Invalid nonce")) {
            return new NonceException(exception.getMessage());
        }
        if (exception.getMessage().contains("Internal server error")) {
            return new InternalServerException((Throwable)((Object)exception));
        }
        return new ExchangeException((Throwable)((Object)exception));
    }
}

