/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitstamp.BitstampAuthenticatedV2;
import org.knowm.xchange.bitstamp.BitstampExchange;
import org.knowm.xchange.bitstamp.BitstampV2;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.bitstamp.dto.BitstampTransferBalanceResponse;
import org.knowm.xchange.bitstamp.dto.account.BitstampBalance;
import org.knowm.xchange.bitstamp.dto.account.BitstampDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampRippleDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampWithdrawal;
import org.knowm.xchange.bitstamp.dto.account.DepositTransaction;
import org.knowm.xchange.bitstamp.dto.account.WithdrawalRequest;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.service.BitstampBaseService;
import org.knowm.xchange.bitstamp.service.BitstampDigestV2;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FundsExceededException;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitstampAccountServiceRaw
extends BitstampBaseService {
    private static final String API_VERSION = "v2";
    private final BitstampDigestV2 signatureCreatorV2;
    private final BitstampAuthenticatedV2 bitstampAuthenticatedV2;
    private final String apiKeyForV2Requests;
    private final SynchronizedValueFactory<String> uuidNonceFactory;
    private final SynchronizedValueFactory<String> timestampFactory;

    protected BitstampAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitstampAuthenticatedV2 = (BitstampAuthenticatedV2)ExchangeRestProxyBuilder.forInterface(BitstampAuthenticatedV2.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.apiKeyForV2Requests = "BITSTAMP " + exchange.getExchangeSpecification().getApiKey();
        this.signatureCreatorV2 = BitstampDigestV2.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getApiKey());
        BitstampExchange bitstampExchange = (BitstampExchange)exchange;
        this.uuidNonceFactory = bitstampExchange.getUuidNonceFactory();
        this.timestampFactory = bitstampExchange.getTimestampFactory();
    }

    public BitstampBalance getBitstampBalance() throws IOException {
        try {
            BitstampBalance bitstampBalance = this.bitstampAuthenticatedV2.getBalance(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION);
            if (bitstampBalance.getError() != null) {
                throw new ExchangeException("Error getting balance. " + bitstampBalance.getError());
            }
            return bitstampBalance;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawBitstampFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawBitstampFunds(currency, amount, address, null);
    }

    public BitstampWithdrawal withdrawBitstampFunds(Currency currency, BigDecimal amount, String address, String tag) throws IOException {
        BitstampWithdrawal response;
        if (currency.equals((Object)Currency.XRP)) {
            Long dt = null;
            try {
                dt = Long.valueOf(tag);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            response = this.withdrawRippleFunds(amount, address, dt);
        } else {
            response = currency.equals((Object)Currency.XLM) ? this.withdrawXLM(amount, address, tag) : this.withdrawAddrAmount(currency, amount, address);
        }
        if (response.error != null) {
            throw new ExchangeException("Failed to withdraw: " + response.error);
        }
        if (response.getId() == null) {
            return null;
        }
        return response;
    }

    public BitstampWithdrawal withdrawAddrAmount(Currency currency, BigDecimal amount, String address) {
        try {
            Class<?> clientClass = this.bitstampAuthenticatedV2.getClass();
            Method withdrawMethod = clientClass.getMethod("withdraw" + currency.getCurrencyCode(), String.class, ParamsDigest.class, SynchronizedValueFactory.class, SynchronizedValueFactory.class, String.class, BigDecimal.class, String.class);
            BitstampWithdrawal response = (BitstampWithdrawal)withdrawMethod.invoke((Object)this.bitstampAuthenticatedV2, new Object[]{this.apiKeyForV2Requests, this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, amount, address});
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call bitstamp withdraw method on authenticated client", e);
        }
    }

    public BitstampWithdrawal withdrawRippleFunds(BigDecimal amount, String address, Long destinationTag) throws IOException {
        BitstampRippleDepositAddress addressAndDt = new BitstampRippleDepositAddress(null, address, destinationTag);
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.withdrawXRP(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, amount, addressAndDt.getAddress(), addressAndDt.getDestinationTag());
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawXLM(BigDecimal amount, String address, String memo) throws IOException {
        try {
            Long longMemo = null;
            if (memo != null) {
                try {
                    longMemo = Long.valueOf(memo);
                }
                catch (NumberFormatException exception) {
                    throw new RuntimeException("Bitstamp supports only numbers for xlm memo field");
                }
            }
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.withdrawXLM(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, amount, address, longMemo);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    private BitstampWithdrawal checkAndReturnWithdrawal(BitstampWithdrawal response) {
        try {
            if (response.hasError()) {
                if (response.toString().contains("You have only")) {
                    throw new FundsExceededException(response.toString());
                }
                throw new ExchangeException("Withdrawing funds from Bitstamp failed: " + response);
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampBitcoinDepositAddress() throws IOException {
        try {
            BitstampDepositAddress bitcoinDepositAddress = this.bitstampAuthenticatedV2.getBitcoinDepositAddress(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION);
            if (bitcoinDepositAddress.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + bitcoinDepositAddress.getError());
            }
            return bitcoinDepositAddress;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampBitcoinCashDepositAddress() throws IOException {
        try {
            BitstampDepositAddress response = this.bitstampAuthenticatedV2.getBitcoinCashDepositAddress(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION);
            if (response.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampLitecoinDepositAddress() throws IOException {
        try {
            BitstampDepositAddress response = this.bitstampAuthenticatedV2.getLitecoinDepositAddress(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION);
            if (response.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampDepositAddress getBitstampEthereumDepositAddress() throws IOException {
        try {
            BitstampDepositAddress response = this.bitstampAuthenticatedV2.getEthereumDepositAddress(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION);
            if (response.getError() != null) {
                throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
            }
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampRippleDepositAddress getRippleDepositAddress() throws IOException {
        return this.bitstampAuthenticatedV2.getRippleIOUDepositAddress(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION);
    }

    public BitstampRippleDepositAddress getXRPDepositAddress() throws IOException {
        return this.bitstampAuthenticatedV2.getXRPDepositAddress(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION);
    }

    public boolean withdrawToRipple(BigDecimal amount, Currency currency, String rippleAddress) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.withdrawToRipple(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, amount, currency.getCurrencyCode(), rippleAddress);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public List<DepositTransaction> getUnconfirmedDeposits() throws IOException {
        try {
            return Arrays.asList(this.bitstampAuthenticatedV2.getUnconfirmedBTCDeposits(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION));
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public List<WithdrawalRequest> getWithdrawalRequests(Long timeDelta) throws IOException {
        try {
            List<WithdrawalRequest> response = Arrays.asList(this.bitstampAuthenticatedV2.getWithdrawalRequests(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, timeDelta));
            return response;
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions, CurrencyPair pair, Long offset, String sort, Long sinceTimestamp, String sinceId) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getUserTransactions(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, new BitstampV2.Pair(pair), numberOfTransactions, offset, sort, sinceTimestamp, sinceId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampUserTransaction[] getBitstampUserTransactions(Long numberOfTransactions, Long offset, String sort, Long sinceTimestamp, String sinceId) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.getUserTransactions(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, numberOfTransactions, offset, sort, sinceTimestamp, sinceId);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampTransferBalanceResponse transferSubAccountBalanceToMain(BigDecimal amount, String currency, String subAccount) throws IOException {
        try {
            return this.bitstampAuthenticatedV2.transferSubAccountBalanceToMain(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, amount, currency, subAccount);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawSepa(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2) throws IOException {
        return this.withdrawSepa(amount, name, IBAN, BIK, address, postalCode, city, countryAlpha2, null);
    }

    public BitstampWithdrawal withdrawSepa(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2, String comment) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.bankWithdrawal(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, amount, BitstampAuthenticatedV2.AccountCurrency.EUR, name, IBAN, BIK, address, postalCode, city, countryAlpha2, BitstampAuthenticatedV2.BankWithdrawalType.sepa, null, null, null, null, null, null, comment);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }

    public BitstampWithdrawal withdrawInternational(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2, String bankName, String bankAddress, String bankPostalCode, String bankCity, String bankCountryAlpha2, BitstampAuthenticatedV2.BankCurrency bankReceiverCurrency) throws IOException {
        return this.withdrawInternational(amount, name, IBAN, BIK, address, postalCode, city, countryAlpha2, bankName, bankAddress, bankPostalCode, bankCity, bankCountryAlpha2, bankReceiverCurrency, null);
    }

    public BitstampWithdrawal withdrawInternational(BigDecimal amount, String name, String IBAN, String BIK, String address, String postalCode, String city, String countryAlpha2, String bankName, String bankAddress, String bankPostalCode, String bankCity, String bankCountryAlpha2, BitstampAuthenticatedV2.BankCurrency bankReceiverCurrency, String comment) throws IOException {
        try {
            BitstampWithdrawal response = this.bitstampAuthenticatedV2.bankWithdrawal(this.apiKeyForV2Requests, (ParamsDigest)this.signatureCreatorV2, this.uuidNonceFactory, this.timestampFactory, API_VERSION, amount, BitstampAuthenticatedV2.AccountCurrency.EUR, name, IBAN, BIK, address, postalCode, city, countryAlpha2, BitstampAuthenticatedV2.BankWithdrawalType.international, bankName, bankAddress, bankPostalCode, bankCity, bankCountryAlpha2, bankReceiverCurrency, comment);
            return this.checkAndReturnWithdrawal(response);
        }
        catch (BitstampException e) {
            throw this.handleError(e);
        }
    }
}

