/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.BitstampAdapters;
import org.knowm.xchange.bitstamp.dto.account.BitstampDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampWithdrawal;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.service.BitstampAccountServiceRaw;
import org.knowm.xchange.bitstamp.service.BitstampTradeHistoryParams;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsIdSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;
import org.knowm.xchange.utils.DateUtils;

public class BitstampAccountService
extends BitstampAccountServiceRaw
implements AccountService {
    public BitstampAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return BitstampAdapters.adaptAccountInfo(this.getBitstampBalance(), this.exchange.getExchangeSpecification().getUserName());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address, String addressTag) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, addressTag, currency, amount, null));
    }

    public String withdrawFunds(WithdrawFundsParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        BitstampWithdrawal response;
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            response = this.withdrawBitstampFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress(), defaultParams.getAddressTag());
            if (response.error != null) {
                throw new ExchangeException("Failed to withdraw: " + response.error);
            }
        } else {
            throw new IllegalStateException("Unsupported WithdrawFundsParams sub class");
        }
        if (response.getId() == null) {
            return null;
        }
        return Long.toString(response.getId());
    }

    public String requestDepositAddress(Currency currency, String ... arguments) throws IOException {
        if (currency.equals((Object)Currency.BTC)) {
            return this.getBitstampBitcoinDepositAddress().getDepositAddress();
        }
        if (currency.equals((Object)Currency.LTC)) {
            return this.getBitstampLitecoinDepositAddress().getDepositAddress();
        }
        if (currency.equals((Object)Currency.XRP)) {
            return this.getXRPDepositAddress().getAddressAndDt();
        }
        if (currency.equals((Object)Currency.BCH)) {
            return this.getBitstampBitcoinCashDepositAddress().getDepositAddress();
        }
        if (currency.equals((Object)Currency.ETH)) {
            return this.getBitstampEthereumDepositAddress().getDepositAddress();
        }
        throw new IllegalStateException("Unsupported currency " + currency);
    }

    public BitstampDepositAddress requestDepositAddressObject(Currency currency, String ... arguments) throws IOException {
        if (currency.equals((Object)Currency.BTC)) {
            return this.getBitstampBitcoinDepositAddress();
        }
        if (currency.equals((Object)Currency.LTC)) {
            return this.getBitstampLitecoinDepositAddress();
        }
        if (currency.equals((Object)Currency.XRP)) {
            return this.getXRPDepositAddress();
        }
        if (currency.equals((Object)Currency.BCH)) {
            return this.getBitstampBitcoinCashDepositAddress();
        }
        if (currency.equals((Object)Currency.ETH)) {
            return this.getBitstampEthereumDepositAddress();
        }
        throw new IllegalStateException("Unsupported currency " + currency);
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BitstampTradeHistoryParams(null, 1000);
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        Long limit = null;
        Long offset = null;
        TradeHistoryParamsSorted.Order sort = null;
        Long sinceTimestamp = null;
        String sinceId = null;
        if (params instanceof TradeHistoryParamPaging) {
            limit = (long)((TradeHistoryParamPaging)params).getPageLength();
        }
        if (params instanceof TradeHistoryParamOffset) {
            offset = ((TradeHistoryParamOffset)params).getOffset();
        }
        if (params instanceof TradeHistoryParamsSorted) {
            sort = ((TradeHistoryParamsSorted)params).getOrder();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            sinceTimestamp = DateUtils.toUnixTimeNullSafe((Date)((TradeHistoryParamsTimeSpan)params).getStartTime());
        }
        if (params instanceof TradeHistoryParamsIdSpan) {
            sinceId = Optional.ofNullable(((TradeHistoryParamsIdSpan)params).getStartId()).orElse(null);
        }
        BitstampUserTransaction[] txs = this.getBitstampUserTransactions(limit, offset, sort == null ? null : sort.toString(), sinceTimestamp, sinceId);
        return BitstampAdapters.adaptFundingHistory(Arrays.asList(txs));
    }
}

