/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.trade;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public enum BitstampOrderStatus {
    Queue,
    Open,
    Canceled,
    Finished;

    private static final Map<String, BitstampOrderStatus> fromString;

    public static BitstampOrderStatus fromString(String orderStatusString) {
        return fromString.get(orderStatusString.toLowerCase());
    }

    static {
        fromString = new HashMap<String, BitstampOrderStatus>();
        for (BitstampOrderStatus orderStatus : BitstampOrderStatus.values()) {
            fromString.put(orderStatus.name().toLowerCase(), orderStatus);
        }
    }

    static class BitstampOrderStatusDeserializer
    extends JsonDeserializer<BitstampOrderStatus> {
        BitstampOrderStatusDeserializer() {
        }

        public BitstampOrderStatus deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            String orderStatusString = node.textValue();
            return BitstampOrderStatus.fromString(orderStatusString);
        }
    }
}

