/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.BitstampAdapters;
import org.knowm.xchange.bitstamp.BitstampAuthenticatedV2;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrder;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.service.BitstampTradeHistoryParams;
import org.knowm.xchange.bitstamp.service.BitstampTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelAllOrders;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamOffset;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsSorted;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.DateUtils;

public class BitstampTradeService
extends BitstampTradeServiceRaw
implements TradeService {
    public BitstampTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException, BitstampException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, IOException {
        List pairs = DefaultOpenOrdersParamCurrencyPair.getPairs((OpenOrdersParams)params, (Exchange)this.exchange);
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (CurrencyPair pair : pairs) {
            BitstampOrder[] openOrders;
            for (BitstampOrder bitstampOrder : openOrders = this.getBitstampOpenOrders(pair)) {
                Order.OrderType orderType = bitstampOrder.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
                String id = Long.toString(bitstampOrder.getId());
                BigDecimal price = bitstampOrder.getPrice();
                limitOrders.add(new LimitOrder(orderType, bitstampOrder.getAmount(), pair, id, bitstampOrder.getDatetime(), price, null, null, null, Order.OrderStatus.NEW));
            }
        }
        return new OpenOrders(limitOrders);
    }

    public String placeMarketOrder(MarketOrder order) throws IOException, BitstampException {
        BitstampAuthenticatedV2.Side side = order.getType().equals((Object)Order.OrderType.BID) ? BitstampAuthenticatedV2.Side.buy : BitstampAuthenticatedV2.Side.sell;
        BitstampOrder bitstampOrder = this.placeBitstampMarketOrder(order.getCurrencyPair(), side, order.getOriginalAmount());
        if (bitstampOrder.getErrorMessage() != null) {
            throw new ExchangeException(bitstampOrder.getErrorMessage());
        }
        return Long.toString(bitstampOrder.getId());
    }

    public String placeLimitOrder(LimitOrder order) throws IOException, BitstampException {
        BitstampAuthenticatedV2.Side side = order.getType().equals((Object)Order.OrderType.BID) ? BitstampAuthenticatedV2.Side.buy : BitstampAuthenticatedV2.Side.sell;
        BitstampOrder bitstampOrder = this.placeBitstampOrder(order.getCurrencyPair(), side, order.getOriginalAmount(), order.getLimitPrice());
        if (bitstampOrder.getErrorMessage() != null) {
            throw new ExchangeException(bitstampOrder.getErrorMessage());
        }
        return Long.toString(bitstampOrder.getId());
    }

    public boolean cancelOrder(String orderId) throws IOException, BitstampException {
        return this.cancelBitstampOrder(Long.parseLong(orderId));
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelAllOrders) {
            return this.cancelAllBitstampOrders();
        }
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        Long limit = null;
        CurrencyPair currencyPair = null;
        Long offset = null;
        TradeHistoryParamsSorted.Order sort = null;
        Long sinceTimestamp = null;
        if (params instanceof TradeHistoryParamPaging) {
            limit = (long)((TradeHistoryParamPaging)params).getPageLength();
        }
        if (params instanceof TradeHistoryParamCurrencyPair) {
            currencyPair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
        }
        if (params instanceof TradeHistoryParamOffset) {
            offset = ((TradeHistoryParamOffset)params).getOffset();
        }
        if (params instanceof TradeHistoryParamsSorted) {
            sort = ((TradeHistoryParamsSorted)params).getOrder();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            sinceTimestamp = DateUtils.toUnixTimeNullSafe((Date)((TradeHistoryParamsTimeSpan)params).getStartTime());
        }
        BitstampUserTransaction[] txs = this.getBitstampUserTransactions(limit, currencyPair, offset, sort == null ? null : sort.toString(), sinceTimestamp);
        return BitstampAdapters.adaptTradeHistory(txs);
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new BitstampTradeHistoryParams(null, 1000);
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        ArrayList<Order> orders = new ArrayList<Order>(orderIds.length);
        for (String orderId : orderIds) {
            orders.add(BitstampAdapters.adaptOrder(orderId, super.getBitstampOrder(Long.parseLong(orderId))));
        }
        return orders;
    }
}

