/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.trade;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.knowm.xchange.bitstamp.BitstampUtils;
import org.knowm.xchange.currency.Currency;

public final class BitstampUserTransaction {
    private final Date datetime;
    private final long id;
    private final long order_id;
    private final TransactionType type;
    private final BigDecimal fee;
    private final Map<String, BigDecimal> amounts = new HashMap<String, BigDecimal>();
    private String base;
    private String counter;
    private BigDecimal price;

    public BitstampUserTransaction(@JsonProperty(value="datetime") String datetime, @JsonProperty(value="id") long id, @JsonProperty(value="order_id") long order_id, @JsonProperty(value="type") TransactionType type, @JsonProperty(value="fee") BigDecimal fee) {
        this.datetime = BitstampUtils.parseDate(datetime);
        this.id = id;
        this.order_id = order_id;
        this.type = type;
        this.fee = fee;
    }

    @JsonAnySetter
    public void setDynamicProperty(String name, Object value) {
        SortedSet ccyCodeList = Currency.getAvailableCurrencyCodes();
        String[] nameArr = name.toUpperCase().split("_");
        String name1 = nameArr[0];
        if (nameArr.length == 2) {
            String name2 = nameArr[1];
            if (ccyCodeList.contains(name1) && ccyCodeList.contains(name2)) {
                this.base = name1;
                this.counter = name2;
                this.price = new BigDecimal(value.toString());
            }
        } else if (nameArr.length == 1 && ccyCodeList.contains(name1)) {
            this.amounts.put(name1, new BigDecimal(value.toString()));
        }
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public long getId() {
        return this.id;
    }

    public long getOrderId() {
        return this.order_id;
    }

    public TransactionType getType() {
        return this.type;
    }

    public boolean isDeposit() {
        return this.type == TransactionType.deposit;
    }

    public boolean isWithdrawal() {
        return this.type == TransactionType.withdrawal;
    }

    public boolean isMarketTrade() {
        return this.type == TransactionType.trade;
    }

    public BigDecimal getCounterAmount() {
        return this.amounts.get(this.counter);
    }

    public BigDecimal getBaseAmount() {
        return this.amounts.get(this.base);
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public String getCounterCurrency() {
        return this.counter;
    }

    public String getBaseCurrency() {
        return this.base;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public String getFeeCurrency() {
        return this.counter;
    }

    public Map<String, BigDecimal> getAmounts() {
        return this.amounts;
    }

    public String toString() {
        return "BitstampUserTransaction [datetime=" + this.datetime + ", id=" + this.id + ", order_id=" + this.order_id + ", type=" + (Object)((Object)this.type) + ", fee=" + this.fee + ", base=" + this.base + ", counter=" + this.counter + ", amounts=" + this.amounts + ", price=" + this.price + "]";
    }

    public static enum TransactionType {
        deposit,
        withdrawal,
        trade,
        rippleWithdrawal,
        rippleDeposit,
        subAccountTransfer;


        @JsonCreator
        public static TransactionType fromString(int type) {
            switch (type) {
                case 0: {
                    return deposit;
                }
                case 1: {
                    return withdrawal;
                }
                case 2: {
                    return trade;
                }
                case 3: {
                    return rippleWithdrawal;
                }
                case 4: {
                    return rippleDeposit;
                }
                case 14: {
                    return subAccountTransfer;
                }
            }
            throw new IllegalArgumentException(type + " has no corresponding value");
        }
    }
}

