/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp;

import java.io.IOException;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampOrderBook;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampPairInfo;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTicker;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTransaction;
import org.knowm.xchange.bitstamp.service.BitstampMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;

@Path(value="api/v2")
@Produces(value={"application/json"})
public interface BitstampV2 {
    @GET
    @Path(value="order_book/{pair}/")
    public BitstampOrderBook getOrderBook(@PathParam(value="pair") Pair var1) throws IOException, BitstampException;

    @GET
    @Path(value="ticker/{pair}/")
    public BitstampTicker getTicker(@PathParam(value="pair") Pair var1) throws IOException, BitstampException;

    @GET
    @Path(value="transactions/{pair}/")
    public BitstampTransaction[] getTransactions(@PathParam(value="pair") Pair var1, @QueryParam(value="time") BitstampMarketDataServiceRaw.BitstampTime var2) throws IOException, BitstampException;

    @GET
    @Path(value="trading-pairs-info/")
    public BitstampPairInfo[] getTradingPairsInfo() throws IOException, BitstampException;

    public static class Pair {
        public final CurrencyPair pair;

        public Pair(CurrencyPair pair) {
            this.pair = pair;
        }

        public Pair(String pair) {
            this(CurrencyPairDeserializer.getCurrencyPairFromString((String)pair));
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Objects.equals(this.pair, ((Pair)o).pair);
        }

        public int hashCode() {
            return Objects.hash(this.pair);
        }

        public String toString() {
            return this.pair == null ? "" : String.format("%s%s", this.pair.base.getCurrencyCode().toLowerCase(), this.pair.counter.getCurrencyCode().toLowerCase());
        }
    }
}

