/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.bitstamp.dto.account.BitstampBalance;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampOrderBook;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampPairInfo;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTicker;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTransaction;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrderStatus;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrderStatusResponse;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrderTransaction;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.order.dto.BitstampGenericOrder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.utils.DateUtils;

public final class BitstampAdapters {
    private BitstampAdapters() {
    }

    public static AccountInfo adaptAccountInfo(BitstampBalance bitstampBalance, String userName) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (BitstampBalance.Balance b : bitstampBalance.getBalances()) {
            Balance xchangeBalance = new Balance(Currency.getInstance((String)b.getCurrency().toUpperCase()), b.getBalance(), b.getAvailable(), b.getReserved(), BigDecimal.ZERO, BigDecimal.ZERO, b.getBalance().subtract(b.getAvailable()).subtract(b.getReserved()), BigDecimal.ZERO);
            balances.add(xchangeBalance);
        }
        return new AccountInfo(userName, bitstampBalance.getFee(), new Wallet[]{Wallet.Builder.from(balances).build()});
    }

    public static OrderBook adaptOrderBook(BitstampOrderBook bitstampOrderBook, CurrencyPair currencyPair) {
        List<LimitOrder> asks = BitstampAdapters.createOrders(currencyPair, Order.OrderType.ASK, bitstampOrderBook.getAsks());
        List<LimitOrder> bids = BitstampAdapters.createOrders(currencyPair, Order.OrderType.BID, bitstampOrderBook.getBids());
        return new OrderBook(bitstampOrderBook.getTimestamp(), asks, bids);
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, List<List<BigDecimal>> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (List<BigDecimal> ask : orders) {
            BitstampAdapters.checkArgument(ask.size() == 2, "Expected a pair (price, amount) but got {0} elements.", ask.size());
            limitOrders.add(BitstampAdapters.createOrder(currencyPair, ask, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, List<BigDecimal> priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.get(1), currencyPair, "", null, priceAndAmount.get(0));
    }

    public static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static Trades adaptTrades(BitstampTransaction[] transactions, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        long lastTradeId = 0L;
        for (BitstampTransaction tx : transactions) {
            long tradeId = tx.getTid();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            trades.add(BitstampAdapters.adaptTrade(tx, currencyPair, 1000));
        }
        return new Trades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Trade adaptTrade(BitstampTransaction tx, CurrencyPair currencyPair, int timeScale) {
        Order.OrderType orderType = tx.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
        String tradeId = String.valueOf(tx.getTid());
        Date date = DateUtils.fromMillisUtc((long)(tx.getDate() * (long)timeScale));
        return new Trade.Builder().type(orderType).originalAmount(tx.getAmount()).currencyPair(currencyPair).price(tx.getPrice()).timestamp(date).id(tradeId).build();
    }

    public static Ticker adaptTicker(BitstampTicker bitstampTicker, CurrencyPair currencyPair) {
        BigDecimal open = bitstampTicker.getOpen();
        BigDecimal last = bitstampTicker.getLast();
        BigDecimal bid = bitstampTicker.getBid();
        BigDecimal ask = bitstampTicker.getAsk();
        BigDecimal high = bitstampTicker.getHigh();
        BigDecimal low = bitstampTicker.getLow();
        BigDecimal vwap = bitstampTicker.getVwap();
        BigDecimal volume = bitstampTicker.getVolume();
        Date timestamp = new Date(bitstampTicker.getTimestamp() * 1000L);
        return new Ticker.Builder().currencyPair(currencyPair).open(open).last(last).bid(bid).ask(ask).high(high).low(low).vwap(vwap).volume(volume).timestamp(timestamp).build();
    }

    public static UserTrades adaptTradeHistory(BitstampUserTransaction[] bitstampUserTransactions) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        long lastTradeId = 0L;
        for (BitstampUserTransaction t : bitstampUserTransactions) {
            if (!t.getType().equals((Object)BitstampUserTransaction.TransactionType.trade)) continue;
            Order.OrderType orderType = t.getCounterAmount().doubleValue() == 0.0 ? (t.getBaseAmount().doubleValue() < 0.0 ? Order.OrderType.ASK : Order.OrderType.BID) : (t.getCounterAmount().doubleValue() > 0.0 ? Order.OrderType.ASK : Order.OrderType.BID);
            long tradeId = t.getId();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            CurrencyPair pair = new CurrencyPair(t.getBaseCurrency().toUpperCase(), t.getCounterCurrency().toUpperCase());
            UserTrade trade = new UserTrade.Builder().type(orderType).originalAmount(t.getBaseAmount().abs()).currencyPair(pair).price(t.getPrice().abs()).timestamp(t.getDatetime()).id(Long.toString(tradeId)).orderId(Long.toString(t.getOrderId())).feeAmount(t.getFee()).feeCurrency(Currency.getInstance((String)t.getFeeCurrency().toUpperCase())).build();
            trades.add(trade);
        }
        return new UserTrades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Map.Entry<String, BigDecimal> findNonzeroAmount(BitstampUserTransaction transaction) throws ExchangeException {
        for (Map.Entry<String, BigDecimal> entry : transaction.getAmounts().entrySet()) {
            if (entry.getValue().abs().compareTo(new BigDecimal(1.0E-6)) != 1) continue;
            return entry;
        }
        throw new ExchangeException("Could not find non-zero amount in transaction (id: " + transaction.getId() + ")");
    }

    public static List<FundingRecord> adaptFundingHistory(List<BitstampUserTransaction> userTransactions) {
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        for (BitstampUserTransaction trans : userTransactions) {
            if (!trans.isDeposit() && !trans.isWithdrawal()) continue;
            FundingRecord.Type type = trans.isDeposit() ? FundingRecord.Type.DEPOSIT : FundingRecord.Type.WITHDRAWAL;
            Map.Entry<String, BigDecimal> amount = BitstampAdapters.findNonzeroAmount(trans);
            FundingRecord record = new FundingRecord(null, trans.getDatetime(), Currency.getInstance((String)amount.getKey()), amount.getValue().abs(), String.valueOf(trans.getId()), null, type, FundingRecord.Status.COMPLETE, null, trans.getFee(), null);
            fundingRecords.add(record);
        }
        return fundingRecords;
    }

    private static CurrencyPair adaptCurrencyPair(BitstampOrderTransaction transaction) {
        if (transaction.getBtc() != null && transaction.getUsd() != null) {
            return CurrencyPair.BTC_USD;
        }
        if (transaction.getLtc() != null && transaction.getUsd() != null) {
            return CurrencyPair.LTC_USD;
        }
        if (transaction.getEth() != null && transaction.getUsd() != null) {
            return CurrencyPair.ETH_USD;
        }
        if (transaction.getXrp() != null && transaction.getUsd() != null) {
            return CurrencyPair.XRP_USD;
        }
        if (transaction.getBch() != null && transaction.getUsd() != null) {
            return CurrencyPair.BCH_USD;
        }
        if (transaction.getBtc() != null && transaction.getEur() != null) {
            return CurrencyPair.BTC_EUR;
        }
        if (transaction.getLtc() != null && transaction.getEur() != null) {
            return CurrencyPair.LTC_EUR;
        }
        if (transaction.getEth() != null && transaction.getEur() != null) {
            return CurrencyPair.ETH_EUR;
        }
        if (transaction.getXrp() != null && transaction.getEur() != null) {
            return CurrencyPair.XRP_EUR;
        }
        if (transaction.getBch() != null && transaction.getEur() != null) {
            return CurrencyPair.BCH_EUR;
        }
        if (transaction.getLtc() != null && transaction.getBtc() != null) {
            return CurrencyPair.LTC_BTC;
        }
        if (transaction.getEth() != null && transaction.getBtc() != null) {
            return CurrencyPair.ETH_BTC;
        }
        if (transaction.getXrp() != null && transaction.getBtc() != null) {
            return CurrencyPair.XRP_BTC;
        }
        if (transaction.getBch() != null && transaction.getBtc() != null) {
            return CurrencyPair.BCH_BTC;
        }
        if (transaction.getBch() != null && transaction.getBtc() != null) {
            return CurrencyPair.BCH_BTC;
        }
        throw new NotYetImplementedForExchangeException();
    }

    private static BigDecimal getBaseCurrencyAmountFromBitstampTransaction(BitstampOrderTransaction bitstampTransaction) {
        CurrencyPair currencyPair = BitstampAdapters.adaptCurrencyPair(bitstampTransaction);
        if (currencyPair.base.equals((Object)Currency.LTC)) {
            return bitstampTransaction.getLtc();
        }
        if (currencyPair.base.equals((Object)Currency.BTC)) {
            return bitstampTransaction.getBtc();
        }
        if (currencyPair.base.equals((Object)Currency.BCH)) {
            return bitstampTransaction.getBch();
        }
        if (currencyPair.base.equals((Object)Currency.ETH)) {
            return bitstampTransaction.getEth();
        }
        if (currencyPair.base.equals((Object)Currency.XRP)) {
            return bitstampTransaction.getXrp();
        }
        throw new NotYetImplementedForExchangeException();
    }

    public static Order.OrderStatus adaptOrderStatus(BitstampOrderStatus bitstampOrderStatus) {
        if (bitstampOrderStatus.equals((Object)BitstampOrderStatus.Queue)) {
            return Order.OrderStatus.PENDING_NEW;
        }
        if (bitstampOrderStatus.equals((Object)BitstampOrderStatus.Finished)) {
            return Order.OrderStatus.FILLED;
        }
        if (bitstampOrderStatus.equals((Object)BitstampOrderStatus.Open)) {
            return Order.OrderStatus.NEW;
        }
        throw new NotYetImplementedForExchangeException();
    }

    public static BitstampGenericOrder adaptOrder(String orderId, BitstampOrderStatusResponse bitstampOrderStatusResponse) {
        BitstampOrderTransaction[] bitstampTransactions = bitstampOrderStatusResponse.getTransactions();
        CurrencyPair currencyPair = BitstampAdapters.adaptCurrencyPair(bitstampTransactions[0]);
        Date date = bitstampTransactions[0].getDatetime();
        BigDecimal averagePrice = Arrays.stream(bitstampTransactions).map(t -> t.getPrice()).reduce((x, y) -> x.add((BigDecimal)y)).get().divide(BigDecimal.valueOf(bitstampTransactions.length), 2);
        BigDecimal cumulativeAmount = Arrays.stream(bitstampTransactions).map(t -> BitstampAdapters.getBaseCurrencyAmountFromBitstampTransaction(t)).reduce((x, y) -> x.add((BigDecimal)y)).get();
        BigDecimal totalFee = Arrays.stream(bitstampTransactions).map(t -> t.getFee()).reduce((x, y) -> x.add((BigDecimal)y)).get();
        Order.OrderStatus orderStatus = BitstampAdapters.adaptOrderStatus(bitstampOrderStatusResponse.getStatus());
        BitstampGenericOrder bitstampGenericOrder = new BitstampGenericOrder(null, null, currencyPair, orderId, date, averagePrice, cumulativeAmount, totalFee, orderStatus);
        return bitstampGenericOrder;
    }

    public static List<CurrencyPair> adaptCurrencyPairs(Collection<BitstampPairInfo> bitstampPairInfo) {
        ArrayList<CurrencyPair> currencyPairs = new ArrayList<CurrencyPair>();
        for (BitstampPairInfo pairInfo : bitstampPairInfo) {
            String[] pairInfos = pairInfo.getName().split("/");
            currencyPairs.add(new CurrencyPair(pairInfos[0], pairInfos[1]));
        }
        return currencyPairs;
    }

    public static ExchangeMetaData adaptMetaData(List<BitstampPairInfo> rawSymbols, ExchangeMetaData metaData) {
        List<CurrencyPair> currencyPairs = BitstampAdapters.adaptCurrencyPairs(rawSymbols);
        Map pairsMap = metaData.getCurrencyPairs();
        Map currenciesMap = metaData.getCurrencies();
        for (CurrencyPair c : currencyPairs) {
            if (!pairsMap.containsKey(c)) {
                pairsMap.put(c, null);
            }
            if (!currenciesMap.containsKey(c.base)) {
                currenciesMap.put(c.base, null);
            }
            if (currenciesMap.containsKey(c.counter)) continue;
            currenciesMap.put(c.counter, null);
        }
        return metaData;
    }
}

