/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.v1;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;

public final class BitfinexUtils {
    private BitfinexUtils() {
    }

    public static String adaptXchangeCurrency(Currency xchangeSymbol) {
        if (xchangeSymbol == null) {
            return null;
        }
        return xchangeSymbol.toString();
    }

    public static String toPairString(CurrencyPair currencyPair) {
        if (currencyPair == null) {
            return null;
        }
        String base = BitfinexUtils.adaptXchangeCurrency(currencyPair.base);
        String counter = BitfinexUtils.adaptXchangeCurrency(currencyPair.counter);
        return "t" + base + BitfinexUtils.currencySeparator(base, counter) + BitfinexUtils.adaptXchangeCurrency(currencyPair.counter);
    }

    public static String toPairStringV1(CurrencyPair currencyPair) {
        if (currencyPair == null) {
            return null;
        }
        String base = StringUtils.lowerCase((String)BitfinexUtils.adaptXchangeCurrency(currencyPair.base));
        String counter = StringUtils.lowerCase((String)BitfinexUtils.adaptXchangeCurrency(currencyPair.counter));
        return base + BitfinexUtils.currencySeparator(base, counter) + BitfinexUtils.adaptXchangeCurrency(currencyPair.counter);
    }

    private static String currencySeparator(String base, String counter) {
        if (base.length() > 3 || counter.length() > 3) {
            return ":";
        }
        return "";
    }

    public static String convertToBitfinexWithdrawalType(String currency) {
        switch (currency.toUpperCase()) {
            case "BTC": {
                return "bitcoin";
            }
            case "LTC": {
                return "litecoin";
            }
            case "ETH": {
                return "ethereum";
            }
            case "ETC": {
                return "ethereumc";
            }
            case "ZEC": {
                return "zcash";
            }
            case "XMR": {
                return "monero";
            }
            case "USD": {
                return "mastercoin";
            }
            case "DASH": {
                return "dash";
            }
            case "XRP": {
                return "ripple";
            }
            case "EOS": {
                return "eos";
            }
            case "NEO": {
                return "neo";
            }
            case "AVT": {
                return "aventus";
            }
            case "QTUM": {
                return "qtum";
            }
            case "EDO": {
                return "eidoo";
            }
            case "BTG": {
                return "bgold";
            }
            case "BCH": {
                return "bcash";
            }
            case "USDT": {
                return "tetheruso";
            }
        }
        throw new ExchangeException("Cannot determine withdrawal type.");
    }
}

