/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.bitfinex.service.BitfinexBaseService;
import org.knowm.xchange.bitfinex.v1.BitfinexOrderType;
import org.knowm.xchange.bitfinex.v1.BitfinexUtils;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexWithdrawalRequest;
import org.knowm.xchange.bitfinex.v1.dto.account.BitfinexWithdrawalResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexAccountInfosResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexActiveCreditsRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexActivePositionsResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexCancelAllOrdersRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexCancelOfferRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexCancelOrderMultiRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexCancelOrderRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexCreditResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexFundingTradeResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexLimitOrder;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexNewOfferRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexNewOrder;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexNewOrderMultiRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexNewOrderMultiResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexNewOrderRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexNonceOnlyRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOfferStatusRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOfferStatusResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderFlags;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderStatusRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrderStatusResponse;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexOrdersHistoryRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexPastFundingTradesRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexPastTradesRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexReplaceOrderRequest;
import org.knowm.xchange.bitfinex.v1.dto.trade.BitfinexTradeResponse;
import org.knowm.xchange.bitfinex.v2.dto.EmptyRequest;
import org.knowm.xchange.bitfinex.v2.dto.trade.ActiveOrder;
import org.knowm.xchange.bitfinex.v2.dto.trade.OrderTrade;
import org.knowm.xchange.bitfinex.v2.dto.trade.Position;
import org.knowm.xchange.bitfinex.v2.dto.trade.Trade;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.FloatingRateLoanOrder;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitfinexTradeServiceRaw
extends BitfinexBaseService {
    public BitfinexTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public BitfinexAccountInfosResponse[] getBitfinexAccountInfos() throws IOException {
        return this.bitfinex.accountInfos(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNonceOnlyRequest("/v1/account_infos", String.valueOf(this.exchange.getNonceFactory().createValue())));
    }

    public BitfinexOrderStatusResponse[] getBitfinexOpenOrders() throws IOException {
        BitfinexOrderStatusResponse[] activeOrders = this.bitfinex.activeOrders(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNonceOnlyRequest("/v1/orders", String.valueOf(this.exchange.getNonceFactory().createValue())));
        return activeOrders;
    }

    public BitfinexOrderStatusResponse[] getBitfinexOrdersHistory(long limit) throws IOException {
        BitfinexOrderStatusResponse[] orders = this.bitfinex.ordersHist(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexOrdersHistoryRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), limit));
        return orders;
    }

    public BitfinexOfferStatusResponse[] getBitfinexOpenOffers() throws IOException {
        BitfinexOfferStatusResponse[] activeOffers = this.bitfinex.activeOffers(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNonceOnlyRequest("/v1/offers", String.valueOf(this.exchange.getNonceFactory().createValue())));
        return activeOffers;
    }

    public BitfinexOrderStatusResponse placeBitfinexMarketOrder(MarketOrder marketOrder, BitfinexOrderType bitfinexOrderType) throws IOException {
        String pair = BitfinexUtils.toPairStringV1(marketOrder.getCurrencyPair());
        String type = marketOrder.getType().equals((Object)Order.OrderType.BID) || marketOrder.getType().equals((Object)Order.OrderType.EXIT_ASK) ? "buy" : "sell";
        String orderType = bitfinexOrderType.toString();
        BitfinexOrderStatusResponse newOrder = this.bitfinex.newOrder(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNewOrderRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), pair, marketOrder.getOriginalAmount(), BigDecimal.ONE, "bitfinex", type, orderType, null));
        return newOrder;
    }

    public BitfinexOrderStatusResponse placeBitfinexLimitOrder(LimitOrder limitOrder, BitfinexOrderType orderType) throws IOException {
        return this.sendLimitOrder(limitOrder, orderType, Long.MIN_VALUE);
    }

    public BitfinexOrderStatusResponse replaceBitfinexLimitOrder(LimitOrder limitOrder, BitfinexOrderType orderType, long replaceOrderId) throws IOException {
        if (limitOrder instanceof BitfinexLimitOrder && ((BitfinexLimitOrder)limitOrder).getOcoStopLimit() != null) {
            throw new ExchangeException("OCO orders are not yet editable");
        }
        return this.sendLimitOrder(limitOrder, orderType, replaceOrderId);
    }

    private BitfinexOrderStatusResponse sendLimitOrder(LimitOrder limitOrder, BitfinexOrderType bitfinexOrderType, long replaceOrderId) throws IOException {
        BitfinexOrderStatusResponse response;
        String pair = BitfinexUtils.toPairStringV1(limitOrder.getCurrencyPair());
        String type = limitOrder.getType().equals((Object)Order.OrderType.BID) || limitOrder.getType().equals((Object)Order.OrderType.EXIT_ASK) ? "buy" : "sell";
        String orderType = bitfinexOrderType.toString();
        boolean isHidden = limitOrder.hasFlag((Order.IOrderFlags)BitfinexOrderFlags.HIDDEN);
        boolean isPostOnly = limitOrder.hasFlag((Order.IOrderFlags)BitfinexOrderFlags.POST_ONLY);
        if (replaceOrderId == Long.MIN_VALUE) {
            BigDecimal ocoAmount = limitOrder instanceof BitfinexLimitOrder ? ((BitfinexLimitOrder)limitOrder).getOcoStopLimit() : null;
            BitfinexNewOrderRequest request = new BitfinexNewOrderRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), pair, limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), "bitfinex", type, orderType, isHidden, isPostOnly, ocoAmount);
            response = this.bitfinex.newOrder(this.apiKey, this.payloadCreator, this.signatureCreator, request);
        } else {
            boolean useRemaining = limitOrder.hasFlag((Order.IOrderFlags)BitfinexOrderFlags.USE_REMAINING);
            BitfinexReplaceOrderRequest request = new BitfinexReplaceOrderRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), replaceOrderId, pair, limitOrder.getOriginalAmount(), limitOrder.getLimitPrice(), "bitfinex", type, orderType, isHidden, isPostOnly, useRemaining);
            response = this.bitfinex.replaceOrder(this.apiKey, this.payloadCreator, this.signatureCreator, request);
        }
        if (limitOrder instanceof BitfinexLimitOrder) {
            BitfinexLimitOrder bitfinexOrder = (BitfinexLimitOrder)limitOrder;
            bitfinexOrder.setResponse(response);
        }
        return response;
    }

    public BitfinexNewOrderMultiResponse placeBitfinexOrderMulti(List<? extends Order> orders, BitfinexOrderType bitfinexOrderType) throws IOException {
        BitfinexNewOrder[] bitfinexOrders = new BitfinexNewOrder[orders.size()];
        for (int i = 0; i < bitfinexOrders.length; ++i) {
            String orderType;
            String type;
            String pair;
            Order o = orders.get(i);
            if (o instanceof LimitOrder) {
                LimitOrder limitOrder = (LimitOrder)o;
                pair = BitfinexUtils.toPairStringV1(limitOrder.getCurrencyPair());
                type = limitOrder.getType().equals((Object)Order.OrderType.BID) || limitOrder.getType().equals((Object)Order.OrderType.EXIT_ASK) ? "buy" : "sell";
                orderType = bitfinexOrderType.toString();
                bitfinexOrders[i] = new BitfinexNewOrder(pair, "bitfinex", type, orderType, limitOrder.getOriginalAmount(), limitOrder.getLimitPrice());
                continue;
            }
            if (!(o instanceof MarketOrder)) continue;
            MarketOrder marketOrder = (MarketOrder)o;
            pair = BitfinexUtils.toPairStringV1(marketOrder.getCurrencyPair());
            type = marketOrder.getType().equals((Object)Order.OrderType.BID) || marketOrder.getType().equals((Object)Order.OrderType.EXIT_ASK) ? "buy" : "sell";
            orderType = bitfinexOrderType.toString();
            bitfinexOrders[i] = new BitfinexNewOrder(pair, "bitfinex", type, orderType, marketOrder.getOriginalAmount(), BigDecimal.ONE);
        }
        BitfinexNewOrderMultiRequest request = new BitfinexNewOrderMultiRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), bitfinexOrders);
        BitfinexNewOrderMultiResponse response = this.bitfinex.newOrderMulti(this.apiKey, this.payloadCreator, this.signatureCreator, request);
        return response;
    }

    public BitfinexOfferStatusResponse placeBitfinexFixedRateLoanOrder(FixedRateLoanOrder loanOrder, BitfinexOrderType orderType) throws IOException {
        String direction = loanOrder.getType() == Order.OrderType.BID ? "loan" : "lend";
        BitfinexOfferStatusResponse newOrderResponse = this.bitfinex.newOffer(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNewOfferRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), loanOrder.getCurrency(), loanOrder.getOriginalAmount(), loanOrder.getRate(), loanOrder.getDayPeriod(), direction));
        return newOrderResponse;
    }

    public BitfinexOfferStatusResponse placeBitfinexFloatingRateLoanOrder(FloatingRateLoanOrder loanOrder, BitfinexOrderType orderType) throws IOException {
        String direction = loanOrder.getType() == Order.OrderType.BID ? "loan" : "lend";
        BitfinexOfferStatusResponse newOrderResponse = this.bitfinex.newOffer(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNewOfferRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), loanOrder.getCurrency(), loanOrder.getOriginalAmount(), new BigDecimal("0.0"), loanOrder.getDayPeriod(), direction));
        return newOrderResponse;
    }

    public boolean cancelBitfinexOrder(String orderId) throws IOException {
        try {
            this.bitfinex.cancelOrders(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexCancelOrderRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), Long.valueOf(orderId)));
            return true;
        }
        catch (BitfinexException e) {
            if (e.getMessage().equals("Order could not be cancelled.")) {
                return false;
            }
            throw e;
        }
    }

    public boolean cancelAllBitfinexOrders() throws IOException {
        try {
            this.bitfinex.cancelAllOrders(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexCancelAllOrdersRequest(String.valueOf(this.exchange.getNonceFactory().createValue())));
            return true;
        }
        catch (BitfinexException e) {
            if (e.getMessage().equals("Orders could not be cancelled.")) {
                return false;
            }
            throw e;
        }
    }

    public boolean cancelBitfinexOrderMulti(List<String> orderIds) throws IOException {
        long[] cancelOrderIds = new long[orderIds.size()];
        for (int i = 0; i < cancelOrderIds.length; ++i) {
            cancelOrderIds[i] = Long.valueOf(orderIds.get(i));
        }
        this.bitfinex.cancelOrderMulti(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexCancelOrderMultiRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), cancelOrderIds));
        return true;
    }

    public BitfinexOfferStatusResponse cancelBitfinexOffer(String offerId) throws IOException {
        BitfinexOfferStatusResponse cancelResponse = this.bitfinex.cancelOffer(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexCancelOfferRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), Long.valueOf(offerId)));
        return cancelResponse;
    }

    public BitfinexOrderStatusResponse getBitfinexOrderStatus(String orderId) throws IOException {
        BitfinexOrderStatusResponse orderStatus = this.bitfinex.orderStatus(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexOrderStatusRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), Long.valueOf(orderId)));
        return orderStatus;
    }

    public BitfinexOfferStatusResponse getBitfinexOfferStatusResponse(String offerId) throws IOException {
        BitfinexOfferStatusResponse offerStatus = this.bitfinex.offerStatus(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexOfferStatusRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), Long.valueOf(offerId)));
        return offerStatus;
    }

    public BitfinexFundingTradeResponse[] getBitfinexFundingHistory(String symbol, Date until, int limit_trades) throws IOException {
        BitfinexFundingTradeResponse[] fundingTrades = this.bitfinex.pastFundingTrades(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexPastFundingTradesRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), symbol, until, limit_trades));
        return fundingTrades;
    }

    public BitfinexTradeResponse[] getBitfinexTradeHistory(String symbol, long startTime, Long endTime, Integer limit, Integer reverse) throws IOException {
        BitfinexTradeResponse[] trades = this.bitfinex.pastTrades(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexPastTradesRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), symbol, startTime, endTime, limit, reverse));
        return trades;
    }

    public BitfinexCreditResponse[] getBitfinexActiveCredits() throws IOException {
        BitfinexCreditResponse[] credits = this.bitfinex.activeCredits(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexActiveCreditsRequest(String.valueOf(this.exchange.getNonceFactory().createValue())));
        return credits;
    }

    public String withdraw(String withdrawType, String walletSelected, BigDecimal amount, String address) throws IOException {
        return this.withdraw(withdrawType, walletSelected, amount, address, null);
    }

    public String withdraw(String withdrawType, String walletSelected, BigDecimal amount, String address, String paymentId) throws IOException {
        BitfinexWithdrawalResponse[] withdrawRepsonse = this.bitfinex.withdraw(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexWithdrawalRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), withdrawType, walletSelected, amount, address, paymentId));
        return withdrawRepsonse[0].getWithdrawalId();
    }

    public BitfinexActivePositionsResponse[] getBitfinexActivePositions() throws IOException {
        BitfinexActivePositionsResponse[] activePositions = this.bitfinex.activePositions(this.apiKey, this.payloadCreator, this.signatureCreator, new BitfinexNonceOnlyRequest("/v1/positions", String.valueOf(this.exchange.getNonceFactory().createValue())));
        return activePositions;
    }

    public List<Position> getBitfinexActivePositionsV2() throws IOException {
        return this.bitfinexV2.activePositions((SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, EmptyRequest.INSTANCE);
    }

    public List<Trade> getBitfinexTradesV2(String symbol, Long startTimeMillis, Long endTimeMillis, Long limit, Long sort) throws IOException {
        if (StringUtils.isBlank((CharSequence)symbol)) {
            return this.bitfinexV2.getTrades((SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, startTimeMillis, endTimeMillis, limit, sort, EmptyRequest.INSTANCE);
        }
        return this.bitfinexV2.getTrades((SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, symbol, startTimeMillis, endTimeMillis, limit, sort, EmptyRequest.INSTANCE);
    }

    public List<ActiveOrder> getBitfinexActiveOrdesV2(String symbol) throws IOException {
        if (symbol == null) {
            symbol = "";
        }
        return this.bitfinexV2.getActiveOrders((SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, symbol, EmptyRequest.INSTANCE);
    }

    public List<OrderTrade> getBitfinexOrderTradesV2(String symbol, Long orderId) throws IOException {
        if (symbol == null || orderId == null) {
            throw new NullPointerException(String.format("Invalid request fields symbol [%s] and orderId [%s] are mandatory for get order trades call", symbol, orderId));
        }
        return this.bitfinexV2.getOrderTrades((SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.apiKey, (ParamsDigest)this.signatureV2, symbol, orderId, EmptyRequest.INSTANCE);
    }
}

