/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitfinex.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitfinex.BitfinexErrorAdapter;
import org.knowm.xchange.bitfinex.dto.BitfinexException;
import org.knowm.xchange.bitfinex.service.BitfinexAdapters;
import org.knowm.xchange.bitfinex.service.BitfinexMarketDataServiceRaw;
import org.knowm.xchange.bitfinex.v1.BitfinexUtils;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLendDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTrade;
import org.knowm.xchange.bitfinex.v2.dto.marketdata.BitfinexTicker;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.LoanOrderBook;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.FloatingRateLoanOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.CurrencyPairsParam;
import org.knowm.xchange.service.marketdata.params.Params;

public class BitfinexMarketDataService
extends BitfinexMarketDataServiceRaw
implements MarketDataService {
    public BitfinexMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return this.getTickerV2(currencyPair, args);
    }

    private Ticker getTickerV1(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            return BitfinexAdapters.adaptTicker(this.getBitfinexTicker(BitfinexUtils.toPairString(currencyPair)), currencyPair);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    private Ticker getTickerV2(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            return BitfinexAdapters.adaptTicker(this.getBitfinexTickerV2(currencyPair));
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            Integer limitBids = null;
            Integer limitAsks = null;
            if (args != null && args.length == 2) {
                Object arg0 = args[0];
                if (!(arg0 instanceof Integer)) {
                    throw new ExchangeException("Argument 0 must be an Integer!");
                }
                limitBids = (Integer)arg0;
                Object arg1 = args[1];
                if (!(arg1 instanceof Integer)) {
                    throw new ExchangeException("Argument 1 must be an Integer!");
                }
                limitAsks = (Integer)arg1;
            }
            BitfinexDepth bitfinexDepth = this.getBitfinexOrderBook(BitfinexUtils.toPairString(currencyPair), limitBids, limitAsks);
            OrderBook orderBook = BitfinexAdapters.adaptOrderBook(bitfinexDepth, currencyPair);
            return orderBook;
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public LoanOrderBook getLendOrderBook(String currency, Object ... args) throws IOException {
        try {
            int limitBids = 50;
            int limitAsks = 50;
            if (args != null && args.length == 2) {
                Object arg0 = args[0];
                if (!(arg0 instanceof Integer)) {
                    throw new ExchangeException("Argument 0 must be an Integer!");
                }
                limitBids = (Integer)arg0;
                Object arg1 = args[1];
                if (!(arg1 instanceof Integer)) {
                    throw new ExchangeException("Argument 1 must be an Integer!");
                }
                limitAsks = (Integer)arg1;
            }
            BitfinexLendDepth bitfinexLendDepth = this.getBitfinexLendBook(currency, limitBids, limitAsks);
            List<FixedRateLoanOrder> fixedRateAsks = BitfinexAdapters.adaptFixedRateLoanOrders(bitfinexLendDepth.getAsks(), currency, "ask", "");
            List<FixedRateLoanOrder> fixedRateBids = BitfinexAdapters.adaptFixedRateLoanOrders(bitfinexLendDepth.getBids(), currency, "bid", "");
            List<FloatingRateLoanOrder> floatingRateAsks = BitfinexAdapters.adaptFloatingRateLoanOrders(bitfinexLendDepth.getAsks(), currency, "ask", "");
            List<FloatingRateLoanOrder> floatingRateBids = BitfinexAdapters.adaptFloatingRateLoanOrders(bitfinexLendDepth.getBids(), currency, "bid", "");
            return new LoanOrderBook(null, fixedRateAsks, fixedRateBids, floatingRateAsks, floatingRateBids);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        return this.getTradesV2(currencyPair, args);
    }

    private Trades getTradesV1(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            long lastTradeTime = 0L;
            if (args != null && args.length == 1) {
                Serializable arg;
                if (args[0] instanceof Number) {
                    arg = (Number)args[0];
                    lastTradeTime = ((Number)arg).longValue() / 1000L;
                } else if (args[0] instanceof Date) {
                    arg = (Date)args[0];
                    lastTradeTime = ((Date)arg).getTime() / 1000L;
                } else {
                    throw new IllegalArgumentException("Extra argument #1, the last trade time, must be a Date or Long (millisecond timestamp) (was " + args[0].getClass() + ")");
                }
            }
            BitfinexTrade[] trades = this.getBitfinexTrades(BitfinexUtils.toPairString(currencyPair), lastTradeTime);
            return BitfinexAdapters.adaptTrades(trades, currencyPair);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    private Trades getTradesV2(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            int limitTrades = 1000;
            long startTimestamp = 0L;
            long endTimestamp = 0L;
            int sort = -1;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] instanceof Number) {
                        Number arg = (Number)args[i];
                        switch (i) {
                            case 0: {
                                limitTrades = arg.intValue();
                                break;
                            }
                            case 1: {
                                startTimestamp = arg.longValue();
                                break;
                            }
                            case 2: {
                                endTimestamp = arg.longValue();
                                break;
                            }
                            case 3: {
                                sort = arg.intValue();
                            }
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Extra argument #" + i + " must be an int/long was: " + args[i].getClass());
                }
            }
            return BitfinexAdapters.adaptPublicTrades(this.getBitfinexPublicTrades(currencyPair, limitTrades, startTimestamp, endTimestamp, sort), currencyPair);
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }

    public List<Ticker> getTickers(Params params) throws IOException {
        try {
            BitfinexTicker[] bitfinexTickers = params instanceof CurrencyPairsParam ? this.getBitfinexTickers(((CurrencyPairsParam)params).getCurrencyPairs()) : this.getBitfinexTickers(null);
            return Arrays.stream(bitfinexTickers).map(BitfinexAdapters::adaptTicker).collect(Collectors.toList());
        }
        catch (BitfinexException e) {
            throw BitfinexErrorAdapter.adapt(e);
        }
    }
}

