/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.ExchangeType;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.account.BinanceCurrencyInfo;
import org.knowm.xchange.binance.dto.account.BinanceFundingHistoryParams;
import org.knowm.xchange.binance.dto.account.BinanceMasterAccountTransferHistoryParams;
import org.knowm.xchange.binance.dto.account.BinanceSubAccountTransferHistoryParams;
import org.knowm.xchange.binance.dto.account.BinanceTradeFee;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.WithdrawResponse;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureAccountInformation;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureCommissionRate;
import org.knowm.xchange.binance.service.BinanceAccountServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.AddressWithTag;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.OpenPosition;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.account.params.RequestDepositAddressParams;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.NetworkWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BinanceAccountService
extends BinanceAccountServiceRaw
implements AccountService {
    public BinanceAccountService(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    private static FundingRecord.Status transferHistoryStatus(String historyStatus) {
        FundingRecord.Status status;
        switch (historyStatus) {
            case "SUCCESS": {
                status = FundingRecord.Status.COMPLETE;
                break;
            }
            default: {
                status = FundingRecord.Status.resolveStatus((String)historyStatus);
                if (status != null) break;
                status = FundingRecord.Status.FAILED;
            }
        }
        return status;
    }

    private static FundingRecord.Status withdrawStatus(int status) {
        switch (status) {
            case 0: 
            case 2: 
            case 4: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.CANCELLED;
            }
            case 3: 
            case 5: {
                return FundingRecord.Status.FAILED;
            }
            case 6: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance withdraw status: " + status);
    }

    private static FundingRecord.Status depositStatus(int status) {
        switch (status) {
            case 0: 
            case 6: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance deposit status: " + status);
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            ArrayList<Wallet> wallets = new ArrayList<Wallet>();
            ArrayList<OpenPosition> openPositions = new ArrayList<OpenPosition>();
            switch ((ExchangeType)((Object)((BinanceExchange)this.exchange).getExchangeSpecification().getExchangeSpecificParametersItem(BinanceExchange.EXCHANGE_TYPE))) {
                case SPOT: {
                    wallets.add(BinanceAdapters.adaptBinanceSpotWallet(this.account()));
                    break;
                }
                case FUTURES: {
                    BinanceFutureAccountInformation futureAccountInformation = this.futuresAccount();
                    wallets.add(BinanceAdapters.adaptBinanceFutureWallet(futureAccountInformation));
                    openPositions.addAll(BinanceAdapters.adaptOpenPositions(futureAccountInformation.getPositions()));
                    break;
                }
            }
            return new AccountInfo(((BinanceExchange)this.exchange).getExchangeSpecification().getUserName(), null, wallets, openPositions, Date.from(Instant.now()));
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public Map<Instrument, Fee> getDynamicTradingFeesByInstrument(String ... category) throws IOException {
        try {
            HashMap<Instrument, Fee> fees = new HashMap<Instrument, Fee>();
            if (!((BinanceExchange)this.exchange).getExchangeSpecification().getExchangeSpecificParametersItem(BinanceExchange.EXCHANGE_TYPE).equals((Object)ExchangeType.SPOT)) {
                throw new UnsupportedOperationException("Only SPOT exchange type is supported");
            }
            List<BinanceTradeFee> binanceTradeFees = this.getTradeFee();
            binanceTradeFees.forEach(binanceTradeFee -> {
                Instrument instrument = BinanceAdapters.adaptSymbol(binanceTradeFee.getSymbol(), false);
                if (instrument != null) {
                    fees.put(instrument, new Fee(new BigDecimal(binanceTradeFee.getMakerCommission()), new BigDecimal(binanceTradeFee.getTakerCommission())));
                }
            });
            return fees;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public Fee getCommissionRateByInstrument(Instrument instrument) throws IOException {
        try {
            if (((BinanceExchange)this.exchange).getExchangeSpecification().getExchangeSpecificParametersItem(BinanceExchange.EXCHANGE_TYPE).equals((Object)ExchangeType.FUTURES)) {
                BinanceFutureCommissionRate binanceFutureCommissionRate = this.getCommissionRate(BinanceAdapters.toSymbol(instrument));
                return new Fee(new BigDecimal(binanceFutureCommissionRate.getMakerCommissionRate()), new BigDecimal(binanceFutureCommissionRate.getTakerCommissionRate()));
            }
            throw new UnsupportedOperationException("Only FUTURES exchange type is supported");
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            return super.withdraw(currency.getCurrencyCode(), address, amount).getId();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, AddressWithTag address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        try {
            WithdrawResponse withdraw;
            if (!(params instanceof DefaultWithdrawFundsParams)) {
                throw new IllegalArgumentException("DefaultWithdrawFundsParams must be provided.");
            }
            if (params instanceof RippleWithdrawFundsParams) {
                RippleWithdrawFundsParams rippleParams = (RippleWithdrawFundsParams)params;
                withdraw = super.withdraw(rippleParams.getCurrency().getCurrencyCode(), rippleParams.getAddress(), rippleParams.getTag(), rippleParams.getAmount(), Currency.XRP.getCurrencyCode());
            } else if (params instanceof NetworkWithdrawFundsParams) {
                NetworkWithdrawFundsParams p = (NetworkWithdrawFundsParams)params;
                withdraw = super.withdraw(p.getCurrency().getCurrencyCode(), p.getAddress(), p.getAddressTag(), p.getAmount(), p.getNetwork());
            } else {
                DefaultWithdrawFundsParams p = (DefaultWithdrawFundsParams)params;
                withdraw = super.withdraw(p.getCurrency().getCurrencyCode(), p.getAddress(), p.getAddressTag(), p.getAmount(), null);
            }
            return withdraw.getId();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        try {
            return super.requestDepositAddress((Currency)currency).address;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public AddressWithTag requestDepositAddressData(Currency currency, String ... args) throws IOException {
        return BinanceAccountService.prepareAddressWithTag(super.requestDepositAddress(currency));
    }

    public AddressWithTag requestDepositAddressData(RequestDepositAddressParams requestDepositAddressParams) throws IOException {
        if (StringUtils.isEmpty((CharSequence)requestDepositAddressParams.getNetwork())) {
            return this.requestDepositAddressData(requestDepositAddressParams.getCurrency(), requestDepositAddressParams.getExtraArguments());
        }
        BinanceCurrencyInfo binanceCurrencyInfo = super.getCurrencyInfo(requestDepositAddressParams.getCurrency()).orElseThrow(() -> new IllegalArgumentException("Currency not supported: " + String.valueOf(requestDepositAddressParams.getCurrency())));
        BinanceCurrencyInfo.Network binanceNetwork = binanceCurrencyInfo.getNetworks().stream().filter(network -> requestDepositAddressParams.getNetwork().equals(network.getId()) || network.getId().equals(requestDepositAddressParams.getCurrency().getCurrencyCode())).findFirst().orElseThrow(() -> new IllegalArgumentException("Network not supported: " + requestDepositAddressParams.getNetwork()));
        DepositAddress depositAddress = super.requestDepositAddressWithNetwork(requestDepositAddressParams.getCurrency(), binanceNetwork.getId());
        return BinanceAccountService.prepareAddressWithTag(depositAddress);
    }

    private static AddressWithTag prepareAddressWithTag(DepositAddress depositAddress) {
        String destinationTag = depositAddress.addressTag == null || depositAddress.addressTag.isEmpty() ? null : depositAddress.addressTag;
        return new AddressWithTag(depositAddress.address, destinationTag);
    }

    public String requestDepositAddress(RequestDepositAddressParams requestDepositAddressParams) throws IOException {
        return this.requestDepositAddressData(requestDepositAddressParams).getAddress();
    }

    public Map<String, AssetDetail> getAssetDetails() throws IOException {
        try {
            return super.requestAssetDetail();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BinanceFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        try {
            HistoryParamsFundingType f;
            TradeHistoryParamCurrency cp;
            String asset = null;
            if (params instanceof TradeHistoryParamCurrency && (cp = (TradeHistoryParamCurrency)params).getCurrency() != null) {
                asset = cp.getCurrency().getCurrencyCode();
            }
            Integer limit = null;
            Integer page = null;
            if (params instanceof TradeHistoryParamLimit) {
                limit = ((TradeHistoryParamLimit)params).getLimit();
            }
            if (params instanceof TradeHistoryParamPaging) {
                page = ((TradeHistoryParamPaging)params).getPageNumber();
            }
            boolean withdrawals = true;
            boolean deposits = true;
            boolean otherInflow = true;
            Long startTime = null;
            Long endTime = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                TradeHistoryParamsTimeSpan tp = (TradeHistoryParamsTimeSpan)params;
                if (tp.getStartTime() != null) {
                    startTime = tp.getStartTime().getTime();
                }
                if (tp.getEndTime() != null) {
                    endTime = tp.getEndTime().getTime();
                }
            }
            if (params instanceof HistoryParamsFundingType && (f = (HistoryParamsFundingType)params).getType() != null) {
                withdrawals = f.getType() == FundingRecord.Type.WITHDRAWAL;
                deposits = f.getType() == FundingRecord.Type.DEPOSIT;
                otherInflow = f.getType() == FundingRecord.Type.OTHER_INFLOW;
            }
            String email = null;
            boolean subAccount = false;
            if (params instanceof BinanceMasterAccountTransferHistoryParams) {
                email = ((BinanceMasterAccountTransferHistoryParams)params).getEmail();
            }
            if (params instanceof BinanceSubAccountTransferHistoryParams) {
                subAccount = true;
            }
            ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
            if (withdrawals) {
                super.withdrawHistory(asset, startTime, endTime).forEach(w -> result.add(FundingRecord.builder().address(w.getAddress()).addressTag(w.getAddressTag()).date(BinanceAdapters.toDate(w.getApplyTime())).currency(Currency.getInstance((String)w.getCoin())).amount(w.getAmount()).internalId(w.getId()).blockchainTransactionHash(w.getTxId()).type(FundingRecord.Type.WITHDRAWAL).status(BinanceAccountService.withdrawStatus(w.getStatus())).fee(w.getTransactionFee()).build()));
            }
            if (deposits) {
                super.depositHistory(asset, startTime, endTime).forEach(d -> result.add(FundingRecord.builder().address(d.getAddress()).addressTag(d.getAddressTag()).date(new Date(d.getInsertTime())).currency(Currency.getInstance((String)d.getCoin())).amount(d.getAmount()).blockchainTransactionHash(d.getTxId()).type(FundingRecord.Type.DEPOSIT).status(BinanceAccountService.depositStatus(d.getStatus())).build()));
            }
            if (otherInflow) {
                super.getAssetDividend(asset, startTime, endTime).forEach(a -> result.add(FundingRecord.builder().date(new Date(a.getDivTime())).currency(Currency.getInstance((String)a.getAsset())).amount(a.getAmount()).blockchainTransactionHash(String.valueOf(a.getTranId())).type(FundingRecord.Type.OTHER_INFLOW).status(FundingRecord.Status.COMPLETE).description(a.getEnInfo()).build()));
            }
            String finalEmail = email;
            if (email != null) {
                super.getTransferHistory(email, startTime, endTime, page, limit).forEach(a -> result.add(FundingRecord.builder().address(finalEmail).date(new Date(a.getTime())).currency(Currency.getInstance((String)a.getAsset())).amount(a.getQty()).type(FundingRecord.Type.INTERNAL_WITHDRAWAL).status(BinanceAccountService.transferHistoryStatus(a.getStatus())).build()));
            }
            if (subAccount) {
                Integer type = deposits && withdrawals ? null : Integer.valueOf(deposits ? 1 : 0);
                super.getSubUserHistory(asset, type, startTime, endTime, limit).forEach(a -> result.add(FundingRecord.builder().address(a.getEmail()).date(new Date(a.getTime())).currency(Currency.getInstance((String)a.getAsset())).amount(a.getQty()).type(a.getType().equals(1) ? FundingRecord.Type.INTERNAL_DEPOSIT : FundingRecord.Type.INTERNAL_WITHDRAWAL).status(FundingRecord.Status.COMPLETE).build()));
            }
            return result;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public boolean setLeverage(Instrument instrument, int leverage) throws IOException {
        if (instrument instanceof FuturesContract) {
            return this.setLeverageRaw((Instrument)instrument, (int)leverage).leverage == leverage;
        }
        return false;
    }
}

