/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.trade;

import org.knowm.xchange.dto.Order;

public enum TrailingFlag implements Order.IOrderFlags
{
    P0_01(1L),
    P0_1(10L),
    P1(100L),
    P10(1000L);

    private final long trailingBip;

    private TrailingFlag(long trailingBip) {
        this.trailingBip = trailingBip;
    }

    public long getTrailingBip() {
        return this.trailingBip;
    }

    static TrailingFlag of(Number percent) {
        switch (percent.toString()) {
            case "0.01": {
                return P0_01;
            }
            case "0.1": {
                return P0_1;
            }
            case "1": {
                return P1;
            }
            case "10": {
                return P10;
            }
        }
        throw new IllegalArgumentException("Invalid trailing " + String.valueOf(percent));
    }
}

