/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.knowm.xchange.binance.config.converter.StringToCurrencyPairConverter;
import org.knowm.xchange.currency.CurrencyPair;

@JsonDeserialize(builder=BinancePriceQuantityBuilder.class)
public final class BinancePriceQuantity {
    @JsonProperty(value="symbol")
    @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
    CurrencyPair currencyPair;
    @JsonProperty(value="bidPrice")
    BigDecimal bidPrice;
    @JsonProperty(value="bidQty")
    BigDecimal bidQty;
    @JsonProperty(value="askPrice")
    BigDecimal askPrice;
    @JsonProperty(value="askQty")
    BigDecimal askQty;

    public boolean isValid() {
        return ObjectUtils.allNotNull((Object[])new Object[]{this.currencyPair, this.bidPrice, this.bidQty, this.askPrice, this.askQty});
    }

    @Generated
    BinancePriceQuantity(CurrencyPair currencyPair, BigDecimal bidPrice, BigDecimal bidQty, BigDecimal askPrice, BigDecimal askQty) {
        this.currencyPair = currencyPair;
        this.bidPrice = bidPrice;
        this.bidQty = bidQty;
        this.askPrice = askPrice;
        this.askQty = askQty;
    }

    @Generated
    public static BinancePriceQuantityBuilder builder() {
        return new BinancePriceQuantityBuilder();
    }

    @Generated
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    @Generated
    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    @Generated
    public BigDecimal getBidQty() {
        return this.bidQty;
    }

    @Generated
    public BigDecimal getAskPrice() {
        return this.askPrice;
    }

    @Generated
    public BigDecimal getAskQty() {
        return this.askQty;
    }

    @Generated
    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.currencyPair = currencyPair;
    }

    @Generated
    public void setBidPrice(BigDecimal bidPrice) {
        this.bidPrice = bidPrice;
    }

    @Generated
    public void setBidQty(BigDecimal bidQty) {
        this.bidQty = bidQty;
    }

    @Generated
    public void setAskPrice(BigDecimal askPrice) {
        this.askPrice = askPrice;
    }

    @Generated
    public void setAskQty(BigDecimal askQty) {
        this.askQty = askQty;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinancePriceQuantity)) {
            return false;
        }
        BinancePriceQuantity other = (BinancePriceQuantity)o;
        CurrencyPair this$currencyPair = this.getCurrencyPair();
        CurrencyPair other$currencyPair = other.getCurrencyPair();
        if (this$currencyPair == null ? other$currencyPair != null : !this$currencyPair.equals(other$currencyPair)) {
            return false;
        }
        BigDecimal this$bidPrice = this.getBidPrice();
        BigDecimal other$bidPrice = other.getBidPrice();
        if (this$bidPrice == null ? other$bidPrice != null : !((Object)this$bidPrice).equals(other$bidPrice)) {
            return false;
        }
        BigDecimal this$bidQty = this.getBidQty();
        BigDecimal other$bidQty = other.getBidQty();
        if (this$bidQty == null ? other$bidQty != null : !((Object)this$bidQty).equals(other$bidQty)) {
            return false;
        }
        BigDecimal this$askPrice = this.getAskPrice();
        BigDecimal other$askPrice = other.getAskPrice();
        if (this$askPrice == null ? other$askPrice != null : !((Object)this$askPrice).equals(other$askPrice)) {
            return false;
        }
        BigDecimal this$askQty = this.getAskQty();
        BigDecimal other$askQty = other.getAskQty();
        return !(this$askQty == null ? other$askQty != null : !((Object)this$askQty).equals(other$askQty));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CurrencyPair $currencyPair = this.getCurrencyPair();
        result = result * 59 + ($currencyPair == null ? 43 : $currencyPair.hashCode());
        BigDecimal $bidPrice = this.getBidPrice();
        result = result * 59 + ($bidPrice == null ? 43 : ((Object)$bidPrice).hashCode());
        BigDecimal $bidQty = this.getBidQty();
        result = result * 59 + ($bidQty == null ? 43 : ((Object)$bidQty).hashCode());
        BigDecimal $askPrice = this.getAskPrice();
        result = result * 59 + ($askPrice == null ? 43 : ((Object)$askPrice).hashCode());
        BigDecimal $askQty = this.getAskQty();
        result = result * 59 + ($askQty == null ? 43 : ((Object)$askQty).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BinancePriceQuantity(currencyPair=" + String.valueOf(this.getCurrencyPair()) + ", bidPrice=" + String.valueOf(this.getBidPrice()) + ", bidQty=" + String.valueOf(this.getBidQty()) + ", askPrice=" + String.valueOf(this.getAskPrice()) + ", askQty=" + String.valueOf(this.getAskQty()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class BinancePriceQuantityBuilder {
        @Generated
        private CurrencyPair currencyPair;
        @Generated
        private BigDecimal bidPrice;
        @Generated
        private BigDecimal bidQty;
        @Generated
        private BigDecimal askPrice;
        @Generated
        private BigDecimal askQty;

        @Generated
        BinancePriceQuantityBuilder() {
        }

        @JsonProperty(value="symbol")
        @JsonDeserialize(converter=StringToCurrencyPairConverter.class)
        @Generated
        public BinancePriceQuantityBuilder currencyPair(CurrencyPair currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        @JsonProperty(value="bidPrice")
        @Generated
        public BinancePriceQuantityBuilder bidPrice(BigDecimal bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        @JsonProperty(value="bidQty")
        @Generated
        public BinancePriceQuantityBuilder bidQty(BigDecimal bidQty) {
            this.bidQty = bidQty;
            return this;
        }

        @JsonProperty(value="askPrice")
        @Generated
        public BinancePriceQuantityBuilder askPrice(BigDecimal askPrice) {
            this.askPrice = askPrice;
            return this;
        }

        @JsonProperty(value="askQty")
        @Generated
        public BinancePriceQuantityBuilder askQty(BigDecimal askQty) {
            this.askQty = askQty;
            return this;
        }

        @Generated
        public BinancePriceQuantity build() {
            return new BinancePriceQuantity(this.currencyPair, this.bidPrice, this.bidQty, this.askPrice, this.askQty);
        }

        @Generated
        public String toString() {
            return "BinancePriceQuantity.BinancePriceQuantityBuilder(currencyPair=" + String.valueOf(this.currencyPair) + ", bidPrice=" + String.valueOf(this.bidPrice) + ", bidQty=" + String.valueOf(this.bidQty) + ", askPrice=" + String.valueOf(this.askPrice) + ", askQty=" + String.valueOf(this.askQty) + ")";
        }
    }
}

