/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import org.knowm.xchange.client.ResilienceRegistries;

public final class BinanceResilience {
    public static final String REQUEST_WEIGHT_RATE_LIMITER = "requestWeight";
    public static final String ORDERS_PER_SECOND_RATE_LIMITER = "ordersPerSecond";
    public static final String RAW_REQUESTS_RATE_LIMITER = "rawRequests";
    public static final String ORDERS_PER_10_SECONDS_RATE_LIMITER = "ordersPer10Seconds";
    public static final String ORDERS_PER_MINUTE_RATE_LIMITER = "ordersPerMINUTE";

    private BinanceResilience() {
    }

    public static ResilienceRegistries createRegistries() {
        ResilienceRegistries registries = new ResilienceRegistries();
        registries.rateLimiters().rateLimiter(REQUEST_WEIGHT_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).timeoutDuration(Duration.ofMinutes(1L)).limitRefreshPeriod(Duration.ofMinutes(1L)).limitForPeriod(6000).build());
        registries.rateLimiters().rateLimiter(ORDERS_PER_SECOND_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(10).build());
        registries.rateLimiters().rateLimiter(RAW_REQUESTS_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).timeoutDuration(Duration.ZERO).limitRefreshPeriod(Duration.ofMinutes(5L)).limitForPeriod(61000).build());
        return registries;
    }

    public static ResilienceRegistries createRegistriesFuture() {
        ResilienceRegistries registries = new ResilienceRegistries();
        registries.rateLimiters().rateLimiter(REQUEST_WEIGHT_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).timeoutDuration(Duration.ofMinutes(1L)).limitRefreshPeriod(Duration.ofMinutes(1L)).limitForPeriod(2400).build());
        registries.rateLimiters().rateLimiter(ORDERS_PER_10_SECONDS_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofSeconds(10L)).limitForPeriod(300).build());
        registries.rateLimiters().rateLimiter(ORDERS_PER_MINUTE_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofMinutes(1L)).limitForPeriod(1200).build());
        registries.rateLimiters().rateLimiter(ORDERS_PER_SECOND_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(Integer.MAX_VALUE).build());
        registries.rateLimiters().rateLimiter(RAW_REQUESTS_RATE_LIMITER, RateLimiterConfig.from((RateLimiterConfig)((RateLimiterConfig)registries.rateLimiters().getDefaultConfig())).timeoutDuration(Duration.ofSeconds(1L)).limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(Integer.MAX_VALUE).build());
        return registries;
    }
}

