/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.binance.BinanceFutures;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureAccountInformation;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureCommissionRate;
import org.knowm.xchange.binance.dto.account.futures.BinancePosition;
import org.knowm.xchange.binance.dto.trade.BinanceCancelledOrder;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.MarginType;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import org.knowm.xchange.binance.dto.trade.futures.BinanceChangeStatus;
import org.knowm.xchange.binance.dto.trade.futures.BinanceFutureNewOrder;
import org.knowm.xchange.binance.dto.trade.futures.BinanceSetLeverage;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="")
@Produces(value={"application/json"})
public interface BinanceFuturesAuthenticated
extends BinanceFutures {
    public static final String SIGNATURE = "signature";
    public static final String X_MBX_APIKEY = "X-MBX-APIKEY";

    @GET
    @Path(value="fapi/v2/account")
    public BinanceFutureAccountInformation futuresAccount(@QueryParam(value="recvWindow") Long var1, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-MBX-APIKEY") String var3, @QueryParam(value="signature") ParamsDigest var4) throws IOException, BinanceException;

    @GET
    @Path(value="fapi/v3/account")
    public BinanceFutureAccountInformation futuresV3Account(@QueryParam(value="recvWindow") Long var1, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-MBX-APIKEY") String var3, @QueryParam(value="signature") ParamsDigest var4) throws IOException, BinanceException;

    @POST
    @Path(value="fapi/v1/order")
    public BinanceFutureNewOrder newOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="reduceOnly") Boolean var6, @FormParam(value="price") BigDecimal var7, @FormParam(value="newClientOrderId") String var8, @FormParam(value="stopPrice") BigDecimal var9, @FormParam(value="closePosition") boolean var10, @FormParam(value="activationPrice") BigDecimal var11, @FormParam(value="callbackRate") BigDecimal var12, @FormParam(value="newOrderRespType") BinanceNewOrder.NewOrderResponseType var13, @FormParam(value="recvWindow") Long var14, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var15, @HeaderParam(value="X-MBX-APIKEY") String var16, @QueryParam(value="signature") ParamsDigest var17) throws IOException, BinanceException;

    @POST
    @Path(value="dapi/v1/order")
    public BinanceFutureNewOrder newInverseOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="reduceOnly") boolean var6, @FormParam(value="price") BigDecimal var7, @FormParam(value="newClientOrderId") String var8, @FormParam(value="stopPrice") BigDecimal var9, @FormParam(value="closePosition") boolean var10, @FormParam(value="activationPrice") BigDecimal var11, @FormParam(value="callbackRate") BigDecimal var12, @FormParam(value="newOrderRespType") BinanceNewOrder.NewOrderResponseType var13, @FormParam(value="recvWindow") Long var14, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var15, @HeaderParam(value="X-MBX-APIKEY") String var16, @QueryParam(value="signature") ParamsDigest var17) throws IOException, BinanceException;

    @POST
    @Path(value="papi/v1/um/order")
    public BinanceFutureNewOrder newPortfolioMarginLinearOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="reduceOnly") boolean var6, @FormParam(value="price") BigDecimal var7, @FormParam(value="newClientOrderId") String var8, @FormParam(value="newOrderRespType") BinanceNewOrder.NewOrderResponseType var9, @FormParam(value="recvWindow") Long var10, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var11, @HeaderParam(value="X-MBX-APIKEY") String var12, @QueryParam(value="signature") ParamsDigest var13) throws IOException, BinanceException;

    @POST
    @Path(value="papi/v1/cm/order")
    public BinanceFutureNewOrder newPortfolioMarginInverseOrder(@FormParam(value="symbol") String var1, @FormParam(value="side") OrderSide var2, @FormParam(value="type") OrderType var3, @FormParam(value="timeInForce") TimeInForce var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="reduceOnly") boolean var6, @FormParam(value="price") BigDecimal var7, @FormParam(value="newClientOrderId") String var8, @FormParam(value="newOrderRespType") BinanceNewOrder.NewOrderResponseType var9, @FormParam(value="recvWindow") Long var10, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var11, @HeaderParam(value="X-MBX-APIKEY") String var12, @QueryParam(value="signature") ParamsDigest var13) throws IOException, BinanceException;

    @DELETE
    @Path(value="fapi/v1/order")
    public BinanceCancelledOrder cancelFutureOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @DELETE
    @Path(value="dapi/v1/order")
    public BinanceCancelledOrder cancelInverseFutureOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @DELETE
    @Path(value="papi/v1/cm/order")
    public BinanceCancelledOrder cancelPortfolioMarginInverseFutureOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @DELETE
    @Path(value="papi/v1/um/order")
    public BinanceCancelledOrder cancelPortfolioMarginFutureOrder(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="fapi/v1/openOrders")
    public List<BinanceOrder> futureOpenOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="dapi/v1/openOrders")
    public List<BinanceOrder> futureOpenInverseOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="/papi/v1/um/openOrders ")
    public List<BinanceOrder> futureOpenPortfolioMarginOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="/papi/v1/cm/openOrders")
    public List<BinanceOrder> futureOpenPortfolioMarginInverseOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="fapi/v1/userTrades")
    public List<BinanceTrade> myFutureTrades(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="startTime") Long var3, @QueryParam(value="endTime") Long var4, @QueryParam(value="fromId") Long var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="recvWindow") Long var7, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var8, @HeaderParam(value="X-MBX-APIKEY") String var9, @QueryParam(value="signature") ParamsDigest var10) throws IOException, BinanceException;

    @GET
    @Path(value="fapi/v1/order")
    public BinanceOrder futureOrderStatus(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="dapi/v1/order")
    public BinanceOrder futureInverseOrderStatus(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="/papi/v1/um/order")
    public BinanceOrder futurePortfolioMarginOrderStatus(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @GET
    @Path(value="/papi/v1/cm/order")
    public BinanceOrder futurePortfolioMarginInverseOrderStatus(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="origClientOrderId") String var3, @QueryParam(value="recvWindow") Long var4, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var5, @HeaderParam(value="X-MBX-APIKEY") String var6, @QueryParam(value="signature") ParamsDigest var7) throws IOException, BinanceException;

    @DELETE
    @Path(value="fapi/v1/allOpenOrders")
    public BinanceChangeStatus cancelAllFutureOpenOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="/fapi/v1/commissionRate")
    public BinanceFutureCommissionRate getFutureCommissionRate(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @PUT
    @Path(value="fapi/v1/order")
    public BinanceFutureNewOrder modifyOrder(@QueryParam(value="orderId") Long var1, @QueryParam(value="origClientOrderId") String var2, @QueryParam(value="symbol") String var3, @QueryParam(value="side") OrderSide var4, @QueryParam(value="quantity") BigDecimal var5, @QueryParam(value="price") BigDecimal var6, @QueryParam(value="recvWindow") Long var7, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var8, @HeaderParam(value="X-MBX-APIKEY") String var9, @QueryParam(value="signature") ParamsDigest var10) throws IOException, BinanceException;

    @GET
    @Path(value="fapi/v1/allOrders")
    public List<BinanceOrder> getAllFutureOrders(@QueryParam(value="symbol") String var1, @QueryParam(value="orderId") Long var2, @QueryParam(value="startTime") Long var3, @QueryParam(value="endTime") Long var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="recvWindow") Long var6, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var7, @HeaderParam(value="X-MBX-APIKEY") String var8, @QueryParam(value="signature") ParamsDigest var9) throws IOException, BinanceException;

    @POST
    @Path(value="/fapi/v1/marginType")
    public BinanceChangeStatus setMarginType(@FormParam(value="symbol") String var1, @FormParam(value="marginType") MarginType var2, @FormParam(value="recvWindow") Long var3, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var4, @HeaderParam(value="X-MBX-APIKEY") String var5, @QueryParam(value="signature") ParamsDigest var6) throws IOException, BinanceException;

    @POST
    @Path(value="/fapi/v1/positionSide/dual")
    public BinanceChangeStatus setDualSidePosition(@FormParam(value="dualSidePosition") boolean var1, @FormParam(value="recvWindow") Long var2, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @POST
    @Path(value="/fapi/v1/leverage")
    public BinanceSetLeverage setLeverage(@FormParam(value="symbol") String var1, @FormParam(value="leverage") int var2, @FormParam(value="recvWindow") Long var3, @FormParam(value="timestamp") SynchronizedValueFactory<Long> var4, @HeaderParam(value="X-MBX-APIKEY") String var5, @QueryParam(value="signature") ParamsDigest var6) throws IOException, BinanceException;

    @GET
    @Path(value="/fapi/v2/positionRisk")
    public List<BinancePosition> getFuturesPositionRisk(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;

    @GET
    @Path(value="/fapi/v3/positionRisk")
    public List<BinancePosition> getFuturesV3PositionRisk(@QueryParam(value="symbol") String var1, @QueryParam(value="recvWindow") Long var2, @QueryParam(value="timestamp") SynchronizedValueFactory<Long> var3, @HeaderParam(value="X-MBX-APIKEY") String var4, @QueryParam(value="signature") ParamsDigest var5) throws IOException, BinanceException;
}

