/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.dto.account.ApiResponse;

public final class AssetDribbletLogResponse
extends ApiResponse<AssetDribbletLogResults> {
    private final AssetDribbletLogResults results;

    public AssetDribbletLogResponse(@JsonProperty(value="results") AssetDribbletLogResults results, @JsonProperty(value="success") boolean success, @JsonProperty(value="msg") String msg) {
        super(success, msg);
        this.results = results;
    }

    @Override
    public AssetDribbletLogResults getData() {
        return this.results;
    }

    public String toString() {
        return "AssetDribbletLogResult [results=" + this.results + ", success=" + this.success + ", msg=" + this.msg + "]";
    }

    public static class AssetDribbletLogResults {
        private BigDecimal total;
        private BnbExchange[] rows;

        public List<BnbExchange> getData() {
            return Arrays.asList(this.rows);
        }

        public BigDecimal getTotal() {
            return this.total;
        }

        public BnbExchange[] getRows() {
            return this.rows;
        }

        public void setTotal(BigDecimal total) {
            this.total = total;
        }

        public void setRows(BnbExchange[] rows) {
            this.rows = rows;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetDribbletLogResults)) {
                return false;
            }
            AssetDribbletLogResults other = (AssetDribbletLogResults)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$total = this.getTotal();
            BigDecimal other$total = other.getTotal();
            if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                return false;
            }
            return Arrays.deepEquals(this.getRows(), other.getRows());
        }

        protected boolean canEqual(Object other) {
            return other instanceof AssetDribbletLogResults;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getRows());
            return result;
        }

        public String toString() {
            return "AssetDribbletLogResponse.AssetDribbletLogResults(total=" + this.getTotal() + ", rows=" + Arrays.deepToString(this.getRows()) + ")";
        }
    }

    public static class BnbExchangeLog {
        private BigInteger tranId;
        private String serviceChargeAmount;
        private String uid;
        private String amount;
        private String operateTime;
        private String transferedAmount;
        private String fromAsset;

        public LocalDateTime getOperateTime() {
            return BinanceAdapters.toLocalDateTime(this.operateTime);
        }

        public BigInteger getTranId() {
            return this.tranId;
        }

        public String getServiceChargeAmount() {
            return this.serviceChargeAmount;
        }

        public String getUid() {
            return this.uid;
        }

        public String getAmount() {
            return this.amount;
        }

        public String getTransferedAmount() {
            return this.transferedAmount;
        }

        public String getFromAsset() {
            return this.fromAsset;
        }

        public void setTranId(BigInteger tranId) {
            this.tranId = tranId;
        }

        public void setServiceChargeAmount(String serviceChargeAmount) {
            this.serviceChargeAmount = serviceChargeAmount;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }

        public void setOperateTime(String operateTime) {
            this.operateTime = operateTime;
        }

        public void setTransferedAmount(String transferedAmount) {
            this.transferedAmount = transferedAmount;
        }

        public void setFromAsset(String fromAsset) {
            this.fromAsset = fromAsset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BnbExchangeLog)) {
                return false;
            }
            BnbExchangeLog other = (BnbExchangeLog)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$tranId = this.getTranId();
            BigInteger other$tranId = other.getTranId();
            if (this$tranId == null ? other$tranId != null : !((Object)this$tranId).equals(other$tranId)) {
                return false;
            }
            String this$serviceChargeAmount = this.getServiceChargeAmount();
            String other$serviceChargeAmount = other.getServiceChargeAmount();
            if (this$serviceChargeAmount == null ? other$serviceChargeAmount != null : !this$serviceChargeAmount.equals(other$serviceChargeAmount)) {
                return false;
            }
            String this$uid = this.getUid();
            String other$uid = other.getUid();
            if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
                return false;
            }
            String this$amount = this.getAmount();
            String other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
                return false;
            }
            LocalDateTime this$operateTime = this.getOperateTime();
            LocalDateTime other$operateTime = other.getOperateTime();
            if (this$operateTime == null ? other$operateTime != null : !((Object)this$operateTime).equals(other$operateTime)) {
                return false;
            }
            String this$transferedAmount = this.getTransferedAmount();
            String other$transferedAmount = other.getTransferedAmount();
            if (this$transferedAmount == null ? other$transferedAmount != null : !this$transferedAmount.equals(other$transferedAmount)) {
                return false;
            }
            String this$fromAsset = this.getFromAsset();
            String other$fromAsset = other.getFromAsset();
            return !(this$fromAsset == null ? other$fromAsset != null : !this$fromAsset.equals(other$fromAsset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BnbExchangeLog;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $tranId = this.getTranId();
            result = result * 59 + ($tranId == null ? 43 : ((Object)$tranId).hashCode());
            String $serviceChargeAmount = this.getServiceChargeAmount();
            result = result * 59 + ($serviceChargeAmount == null ? 43 : $serviceChargeAmount.hashCode());
            String $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
            String $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
            LocalDateTime $operateTime = this.getOperateTime();
            result = result * 59 + ($operateTime == null ? 43 : ((Object)$operateTime).hashCode());
            String $transferedAmount = this.getTransferedAmount();
            result = result * 59 + ($transferedAmount == null ? 43 : $transferedAmount.hashCode());
            String $fromAsset = this.getFromAsset();
            result = result * 59 + ($fromAsset == null ? 43 : $fromAsset.hashCode());
            return result;
        }

        public String toString() {
            return "AssetDribbletLogResponse.BnbExchangeLog(tranId=" + this.getTranId() + ", serviceChargeAmount=" + this.getServiceChargeAmount() + ", uid=" + this.getUid() + ", amount=" + this.getAmount() + ", operateTime=" + this.getOperateTime() + ", transferedAmount=" + this.getTransferedAmount() + ", fromAsset=" + this.getFromAsset() + ")";
        }
    }

    public static class BnbExchange {
        private String transfered_total;
        private String service_charge_total;
        private BigInteger tran_id;
        private BnbExchangeLog[] logs;
        private String operate_time;

        public List<BnbExchangeLog> getData() {
            return Arrays.asList(this.logs);
        }

        public LocalDateTime getOperateTime() {
            return BinanceAdapters.toLocalDateTime(this.operate_time);
        }

        public String getTransfered_total() {
            return this.transfered_total;
        }

        public String getService_charge_total() {
            return this.service_charge_total;
        }

        public BigInteger getTran_id() {
            return this.tran_id;
        }

        public BnbExchangeLog[] getLogs() {
            return this.logs;
        }

        public String getOperate_time() {
            return this.operate_time;
        }

        public void setTransfered_total(String transfered_total) {
            this.transfered_total = transfered_total;
        }

        public void setService_charge_total(String service_charge_total) {
            this.service_charge_total = service_charge_total;
        }

        public void setTran_id(BigInteger tran_id) {
            this.tran_id = tran_id;
        }

        public void setLogs(BnbExchangeLog[] logs) {
            this.logs = logs;
        }

        public void setOperate_time(String operate_time) {
            this.operate_time = operate_time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BnbExchange)) {
                return false;
            }
            BnbExchange other = (BnbExchange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$transfered_total = this.getTransfered_total();
            String other$transfered_total = other.getTransfered_total();
            if (this$transfered_total == null ? other$transfered_total != null : !this$transfered_total.equals(other$transfered_total)) {
                return false;
            }
            String this$service_charge_total = this.getService_charge_total();
            String other$service_charge_total = other.getService_charge_total();
            if (this$service_charge_total == null ? other$service_charge_total != null : !this$service_charge_total.equals(other$service_charge_total)) {
                return false;
            }
            BigInteger this$tran_id = this.getTran_id();
            BigInteger other$tran_id = other.getTran_id();
            if (this$tran_id == null ? other$tran_id != null : !((Object)this$tran_id).equals(other$tran_id)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getLogs(), other.getLogs())) {
                return false;
            }
            String this$operate_time = this.getOperate_time();
            String other$operate_time = other.getOperate_time();
            return !(this$operate_time == null ? other$operate_time != null : !this$operate_time.equals(other$operate_time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BnbExchange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $transfered_total = this.getTransfered_total();
            result = result * 59 + ($transfered_total == null ? 43 : $transfered_total.hashCode());
            String $service_charge_total = this.getService_charge_total();
            result = result * 59 + ($service_charge_total == null ? 43 : $service_charge_total.hashCode());
            BigInteger $tran_id = this.getTran_id();
            result = result * 59 + ($tran_id == null ? 43 : ((Object)$tran_id).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getLogs());
            String $operate_time = this.getOperate_time();
            result = result * 59 + ($operate_time == null ? 43 : $operate_time.hashCode());
            return result;
        }

        public String toString() {
            return "AssetDribbletLogResponse.BnbExchange(transfered_total=" + this.getTransfered_total() + ", service_charge_total=" + this.getService_charge_total() + ", tran_id=" + this.getTran_id() + ", logs=" + Arrays.deepToString(this.getLogs()) + ", operate_time=" + this.getOperate_time() + ")";
        }
    }
}

