/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.query.DnsQuery;
import org.kiwiproject.consul.model.query.PreparedQuery;
import org.kiwiproject.consul.model.query.ServiceQuery;
import org.kiwiproject.consul.model.query.Template;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="PreparedQuery", generator="Immutables")
public final class ImmutablePreparedQuery
extends PreparedQuery {
    @Nullable
    private final Template template;
    private final String name;
    @Nullable
    private final String session;
    @Nullable
    private final String token;
    private final ServiceQuery service;
    @Nullable
    private final DnsQuery dns;

    private ImmutablePreparedQuery(@Nullable Template template, String name, @Nullable String session, @Nullable String token, ServiceQuery service, @Nullable DnsQuery dns) {
        this.template = template;
        this.name = name;
        this.session = session;
        this.token = token;
        this.service = service;
        this.dns = dns;
    }

    @Override
    @JsonProperty(value="Template")
    public Optional<Template> getTemplate() {
        return Optional.ofNullable(this.template);
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Session")
    public Optional<String> getSession() {
        return Optional.ofNullable(this.session);
    }

    @Override
    @JsonProperty(value="Token")
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Override
    @JsonProperty(value="Service")
    public ServiceQuery getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="DNS")
    public Optional<DnsQuery> getDns() {
        return Optional.ofNullable(this.dns);
    }

    public final ImmutablePreparedQuery withTemplate(Template value) {
        Template newValue = Objects.requireNonNull(value, "template");
        if (this.template == newValue) {
            return this;
        }
        return new ImmutablePreparedQuery(newValue, this.name, this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withTemplate(Optional<? extends Template> optional) {
        Template value = optional.orElse(null);
        if (this.template == value) {
            return this;
        }
        return new ImmutablePreparedQuery(value, this.name, this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, newValue, this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(String value) {
        String newValue = Objects.requireNonNull(value, "session");
        if (Objects.equals(this.session, newValue)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, newValue, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.session, value)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, value, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, newValue, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, value, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withService(ServiceQuery value) {
        if (this.service == value) {
            return this;
        }
        ServiceQuery newValue = Objects.requireNonNull(value, "service");
        return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, newValue, this.dns);
    }

    public final ImmutablePreparedQuery withDns(DnsQuery value) {
        DnsQuery newValue = Objects.requireNonNull(value, "dns");
        if (this.dns == newValue) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, newValue);
    }

    public final ImmutablePreparedQuery withDns(Optional<? extends DnsQuery> optional) {
        DnsQuery value = optional.orElse(null);
        if (this.dns == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreparedQuery && this.equalsByValue((ImmutablePreparedQuery)another);
    }

    private boolean equalsByValue(ImmutablePreparedQuery another) {
        return Objects.equals(this.template, another.template) && this.name.equals(another.name) && Objects.equals(this.session, another.session) && Objects.equals(this.token, another.token) && this.service.equals(another.service) && Objects.equals(this.dns, another.dns);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.template);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.session);
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + this.service.hashCode();
        h += (h << 5) + Objects.hashCode(this.dns);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PreparedQuery").omitNullValues().add("template", (Object)this.template).add("name", (Object)this.name).add("session", (Object)this.session).add("token", (Object)this.token).add("service", (Object)this.service).add("dns", (Object)this.dns).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePreparedQuery fromJson(Json json) {
        Builder builder = ImmutablePreparedQuery.builder();
        if (json._template != null) {
            builder.template(json._template);
        }
        if (json._name != null) {
            builder.name(json._name);
        }
        if (json._session != null) {
            builder.session(json._session);
        }
        if (json._token != null) {
            builder.token(json._token);
        }
        if (json._service != null) {
            builder.service(json._service);
        }
        if (json._dns != null) {
            builder.dns(json._dns);
        }
        return builder.build();
    }

    public static ImmutablePreparedQuery copyOf(PreparedQuery instance) {
        if (instance instanceof ImmutablePreparedQuery) {
            return (ImmutablePreparedQuery)instance;
        }
        return ImmutablePreparedQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PreparedQuery", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        @Nullable
        private Template template;
        @Nullable
        private String name;
        @Nullable
        private String session;
        @Nullable
        private String token;
        @Nullable
        private ServiceQuery service;
        @Nullable
        private DnsQuery dns;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PreparedQuery instance) {
            Optional<String> tokenOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Template> templateOptional = instance.getTemplate();
            if (templateOptional.isPresent()) {
                this.template(templateOptional);
            }
            this.name(instance.getName());
            Optional<String> sessionOptional = instance.getSession();
            if (sessionOptional.isPresent()) {
                this.session(sessionOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            this.service(instance.getService());
            Optional<DnsQuery> dnsOptional = instance.getDns();
            if (dnsOptional.isPresent()) {
                this.dns(dnsOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder template(Template template) {
            this.template = Objects.requireNonNull(template, "template");
            return this;
        }

        @JsonProperty(value="Template")
        @CanIgnoreReturnValue
        public final Builder template(Optional<? extends Template> template) {
            this.template = template.orElse(null);
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder session(String session) {
            this.session = Objects.requireNonNull(session, "session");
            return this;
        }

        @JsonProperty(value="Session")
        @CanIgnoreReturnValue
        public final Builder session(Optional<String> session) {
            this.session = session.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        @JsonProperty(value="Token")
        @CanIgnoreReturnValue
        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(ServiceQuery service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dns(DnsQuery dns) {
            this.dns = Objects.requireNonNull(dns, "dns");
            return this;
        }

        @JsonProperty(value="DNS")
        @CanIgnoreReturnValue
        public final Builder dns(Optional<? extends DnsQuery> dns) {
            this.dns = dns.orElse(null);
            return this;
        }

        public ImmutablePreparedQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreparedQuery(this.template, this.name, this.session, this.token, this.service, this.dns);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build PreparedQuery, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="PreparedQuery", generator="Immutables")
    static final class Json
    extends PreparedQuery {
        @JsonIgnore
        @Nullable
        Optional<Template> _template = Optional.empty();
        @JsonIgnore
        @Nullable
        String _name;
        @JsonIgnore
        @Nullable
        Optional<String> _session = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _token = Optional.empty();
        @JsonIgnore
        @Nullable
        ServiceQuery _service;
        @JsonIgnore
        @Nullable
        Optional<DnsQuery> _dns = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Template")
        public void setTemplate(Optional<Template> template) {
            this._template = template;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this._name = name;
        }

        @JsonProperty(value="Session")
        public void setSession(Optional<String> session) {
            this._session = session;
        }

        @JsonProperty(value="Token")
        public void setToken(Optional<String> token) {
            this._token = token;
        }

        @JsonProperty(value="Service")
        public void setService(ServiceQuery service) {
            this._service = service;
        }

        @JsonProperty(value="DNS")
        public void setDns(Optional<DnsQuery> dns) {
            this._dns = dns;
        }

        @Override
        public Optional<Template> getTemplate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSession() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceQuery getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DnsQuery> getDns() {
            throw new UnsupportedOperationException();
        }
    }
}

