/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.health.HealthCheck;
import org.kiwiproject.consul.model.health.Node;
import org.kiwiproject.consul.model.health.Service;
import org.kiwiproject.consul.model.health.ServiceHealth;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceHealth", generator="Immutables")
public final class ImmutableServiceHealth
extends ServiceHealth {
    private final Node node;
    private final Service service;
    private final ImmutableList<HealthCheck> checks;

    private ImmutableServiceHealth(Node node, Service service, ImmutableList<HealthCheck> checks) {
        this.node = node;
        this.service = service;
        this.checks = checks;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Service")
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="Checks")
    @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
    public ImmutableList<HealthCheck> getChecks() {
        return this.checks;
    }

    public final ImmutableServiceHealth withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        Node newValue = Objects.requireNonNull(value, "node");
        return new ImmutableServiceHealth(newValue, this.service, this.checks);
    }

    public final ImmutableServiceHealth withService(Service value) {
        if (this.service == value) {
            return this;
        }
        Service newValue = Objects.requireNonNull(value, "service");
        return new ImmutableServiceHealth(this.node, newValue, this.checks);
    }

    public final ImmutableServiceHealth withChecks(HealthCheck ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableServiceHealth(this.node, this.service, (ImmutableList<HealthCheck>)newValue);
    }

    public final ImmutableServiceHealth withChecks(Iterable<? extends HealthCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceHealth(this.node, this.service, (ImmutableList<HealthCheck>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceHealth && this.equalsByValue((ImmutableServiceHealth)another);
    }

    private boolean equalsByValue(ImmutableServiceHealth another) {
        return this.node.equals(another.node) && this.service.equals(another.service) && this.checks.equals(another.checks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.service.hashCode();
        h += (h << 5) + this.checks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceHealth").omitNullValues().add("node", (Object)this.node).add("service", (Object)this.service).add("checks", this.checks).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceHealth fromJson(Json json) {
        Builder builder = ImmutableServiceHealth.builder();
        if (json._node != null) {
            builder.node(json._node);
        }
        if (json._service != null) {
            builder.service(json._service);
        }
        if (json._checks != null) {
            builder.addAllChecks(json._checks);
        }
        return builder.build();
    }

    public static ImmutableServiceHealth copyOf(ServiceHealth instance) {
        if (instance instanceof ImmutableServiceHealth) {
            return (ImmutableServiceHealth)instance;
        }
        return ImmutableServiceHealth.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceHealth", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        @Nullable
        private Node node;
        @Nullable
        private Service service;
        private ImmutableList.Builder<HealthCheck> checks = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceHealth instance) {
            Objects.requireNonNull(instance, "instance");
            this.node(instance.getNode());
            this.service(instance.getService());
            this.addAllChecks(instance.getChecks());
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder node(Node node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(Service service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck element) {
            this.checks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck ... elements) {
            this.checks.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        @CanIgnoreReturnValue
        public final Builder checks(Iterable<? extends HealthCheck> elements) {
            this.checks = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
            this.checks.addAll(elements);
            return this;
        }

        public ImmutableServiceHealth build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceHealth(this.node, this.service, (ImmutableList<HealthCheck>)this.checks.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build ServiceHealth, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ServiceHealth", generator="Immutables")
    static final class Json
    extends ServiceHealth {
        @JsonIgnore
        @Nullable
        Node _node;
        @JsonIgnore
        @Nullable
        Service _service;
        @JsonIgnore
        @Nullable
        List<HealthCheck> _checks = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this._node = node;
        }

        @JsonProperty(value="Service")
        public void setService(Service service) {
            this._service = service;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        public void setChecks(List<HealthCheck> checks) {
            this._checks = checks;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Service getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<HealthCheck> getChecks() {
            throw new UnsupportedOperationException();
        }
    }
}

