/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.acl.BasePolicyResponse;
import org.kiwiproject.consul.model.acl.PolicyResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="PolicyResponse", generator="Immutables")
public final class ImmutablePolicyResponse
extends PolicyResponse {
    private final String id;
    private final String name;
    @Nullable
    private final List<String> datacenters;
    private final String hash;
    private final BigInteger createIndex;
    private final BigInteger modifyIndex;

    private ImmutablePolicyResponse(String id, String name, @Nullable List<String> datacenters, String hash, BigInteger createIndex, BigInteger modifyIndex) {
        this.id = id;
        this.name = name;
        this.datacenters = datacenters;
        this.hash = hash;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<List<String>> datacenters() {
        return Optional.ofNullable(this.datacenters);
    }

    @Override
    @JsonProperty(value="Hash")
    public String hash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public BigInteger createIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public BigInteger modifyIndex() {
        return this.modifyIndex;
    }

    public final ImmutablePolicyResponse withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyResponse(newValue, this.name, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, newValue, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withDatacenters(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "datacenters");
        if (this.datacenters == newValue) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, newValue, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withDatacenters(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.datacenters == value) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, value, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, newValue, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withCreateIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "createIndex");
        if (this.createIndex.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, this.hash, newValue, this.modifyIndex);
    }

    public final ImmutablePolicyResponse withModifyIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
        if (this.modifyIndex.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, this.hash, this.createIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolicyResponse && this.equalsByValue((ImmutablePolicyResponse)another);
    }

    private boolean equalsByValue(ImmutablePolicyResponse another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.datacenters, another.datacenters) && this.hash.equals(another.hash) && this.createIndex.equals(another.createIndex) && this.modifyIndex.equals(another.modifyIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.datacenters);
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.createIndex.hashCode();
        h += (h << 5) + this.modifyIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PolicyResponse").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("datacenters", this.datacenters).add("hash", (Object)this.hash).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePolicyResponse fromJson(Json json) {
        Builder builder = ImmutablePolicyResponse.builder();
        if (json._id != null) {
            builder.id(json._id);
        }
        if (json._name != null) {
            builder.name(json._name);
        }
        if (json._datacenters != null) {
            builder.datacenters(json._datacenters);
        }
        if (json._hash != null) {
            builder.hash(json._hash);
        }
        if (json._createIndex != null) {
            builder.createIndex(json._createIndex);
        }
        if (json._modifyIndex != null) {
            builder.modifyIndex(json._modifyIndex);
        }
        return builder.build();
    }

    public static ImmutablePolicyResponse copyOf(PolicyResponse instance) {
        if (instance instanceof ImmutablePolicyResponse) {
            return (ImmutablePolicyResponse)instance;
        }
        return ImmutablePolicyResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PolicyResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private static final long INIT_BIT_CREATE_INDEX = 8L;
        private static final long INIT_BIT_MODIFY_INDEX = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private List<String> datacenters;
        @Nullable
        private String hash;
        @Nullable
        private BigInteger createIndex;
        @Nullable
        private BigInteger modifyIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BasePolicyResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PolicyResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            if (object instanceof BasePolicyResponse) {
                BasePolicyResponse instance = (BasePolicyResponse)object;
                Optional<List<String>> datacentersOptional = instance.datacenters();
                if (datacentersOptional.isPresent()) {
                    this.datacenters(datacentersOptional);
                }
                this.name(instance.name());
                this.id(instance.id());
                this.modifyIndex(instance.modifyIndex());
                this.createIndex(instance.createIndex());
                this.hash(instance.hash());
            }
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenters(List<String> datacenters) {
            this.datacenters = Objects.requireNonNull(datacenters, "datacenters");
            return this;
        }

        @JsonProperty(value="Datacenters")
        @CanIgnoreReturnValue
        public final Builder datacenters(Optional<? extends List<String>> datacenters) {
            this.datacenters = datacenters.orElse(null);
            return this;
        }

        @JsonProperty(value="Hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="CreateIndex")
        @CanIgnoreReturnValue
        public final Builder createIndex(BigInteger createIndex) {
            this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="ModifyIndex")
        @CanIgnoreReturnValue
        public final Builder modifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutablePolicyResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePolicyResponse(this.id, this.name, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("modifyIndex");
            }
            return "Cannot build PolicyResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="PolicyResponse", generator="Immutables")
    static final class Json
    extends PolicyResponse {
        @JsonIgnore
        @Nullable
        String _id;
        @JsonIgnore
        @Nullable
        String _name;
        @JsonIgnore
        @Nullable
        Optional<List<String>> _datacenters = Optional.empty();
        @JsonIgnore
        @Nullable
        String _hash;
        @JsonIgnore
        @Nullable
        BigInteger _createIndex;
        @JsonIgnore
        @Nullable
        BigInteger _modifyIndex;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this._id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this._name = name;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<List<String>> datacenters) {
            this._datacenters = datacenters;
        }

        @JsonProperty(value="Hash")
        public void setHash(String hash) {
            this._hash = hash;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(BigInteger createIndex) {
            this._createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(BigInteger modifyIndex) {
            this._modifyIndex = modifyIndex;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> datacenters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger createIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger modifyIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

