/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.EventResponse;
import org.kiwiproject.consul.model.event.Event;

@Generated(from="EventResponse", generator="Immutables")
public final class ImmutableEventResponse
extends EventResponse {
    private final ImmutableList<Event> events;
    private final BigInteger index;

    private ImmutableEventResponse(Iterable<? extends Event> events, BigInteger index) {
        this.events = ImmutableList.copyOf(events);
        this.index = Objects.requireNonNull(index, "index");
    }

    private ImmutableEventResponse(ImmutableEventResponse original, ImmutableList<Event> events, BigInteger index) {
        this.events = events;
        this.index = index;
    }

    @JsonProperty(value="events")
    public ImmutableList<Event> getEvents() {
        return this.events;
    }

    @Override
    @JsonProperty(value="index")
    public BigInteger getIndex() {
        return this.index;
    }

    public final ImmutableEventResponse withEvents(Event ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEventResponse(this, (ImmutableList<Event>)newValue, this.index);
    }

    public final ImmutableEventResponse withEvents(Iterable<? extends Event> elements) {
        if (this.events == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEventResponse(this, (ImmutableList<Event>)newValue, this.index);
    }

    public final ImmutableEventResponse withIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "index");
        if (this.index.equals(newValue)) {
            return this;
        }
        return new ImmutableEventResponse(this, this.events, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEventResponse && this.equalTo(0, (ImmutableEventResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableEventResponse another) {
        return this.events.equals(another.events) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.events.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EventResponse").omitNullValues().add("events", this.events).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEventResponse fromJson(Json json) {
        Builder builder = ImmutableEventResponse.builder();
        if (json.events != null) {
            builder.addAllEvents(json.events);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableEventResponse of(List<Event> events, BigInteger index) {
        return ImmutableEventResponse.of(events, index);
    }

    public static ImmutableEventResponse of(Iterable<? extends Event> events, BigInteger index) {
        return new ImmutableEventResponse(events, index);
    }

    public static ImmutableEventResponse copyOf(EventResponse instance) {
        if (instance instanceof ImmutableEventResponse) {
            return (ImmutableEventResponse)instance;
        }
        return ImmutableEventResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EventResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Event> events = ImmutableList.builder();
        @Nullable
        private BigInteger index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EventResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEvents(instance.getEvents());
            this.index(instance.getIndex());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(Event element) {
            this.events.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(Event ... elements) {
            this.events.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="events")
        @CanIgnoreReturnValue
        public final Builder events(Iterable<? extends Event> elements) {
            this.events = ImmutableList.builder();
            return this.addAllEvents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEvents(Iterable<? extends Event> elements) {
            this.events.addAll(elements);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(BigInteger index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableEventResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEventResponse(null, (ImmutableList<Event>)this.events.build(), this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build EventResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EventResponse", generator="Immutables")
    static final class Json
    extends EventResponse {
        @Nullable
        List<Event> events = ImmutableList.of();
        @Nullable
        BigInteger index;

        Json() {
        }

        @JsonProperty(value="events")
        public void setEvents(List<Event> events) {
            this.events = events;
        }

        @JsonProperty(value="index")
        public void setIndex(BigInteger index) {
            this.index = index;
        }

        @Override
        public List<Event> getEvents() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

