/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.kiwiproject.consul.BaseClient;
import org.kiwiproject.consul.async.ConsulResponseCallback;
import org.kiwiproject.consul.async.EventResponseCallback;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.model.ConsulResponse;
import org.kiwiproject.consul.model.EventResponse;
import org.kiwiproject.consul.model.ImmutableEventResponse;
import org.kiwiproject.consul.model.event.Event;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import org.kiwiproject.consul.option.EventOptions;
import org.kiwiproject.consul.option.Options;
import org.kiwiproject.consul.option.QueryOptions;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class EventClient
extends BaseClient {
    private static final String CLIENT_NAME = "event";
    private final Api api;

    EventClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public Event fireEvent(String name, EventOptions eventOptions, String payload) {
        return this.http.extract(this.api.fireEvent(name, RequestBody.create((String)payload, (MediaType)MediaType.parse((String)"text/plain")), eventOptions.toQuery()), new Integer[0]);
    }

    public Event fireEvent(String name) {
        return this.fireEvent(name, Options.BLANK_EVENT_OPTIONS);
    }

    public Event fireEvent(String name, EventOptions eventOptions) {
        return this.http.extract(this.api.fireEvent(name, eventOptions.toQuery()), new Integer[0]);
    }

    public Event fireEvent(String name, String payload) {
        return this.fireEvent(name, Options.BLANK_EVENT_OPTIONS, payload);
    }

    public EventResponse listEvents(String name, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            query.put("name", name);
        }
        ConsulResponse<List<Event>> response = this.http.extractConsulResponse(this.api.listEvents(query), new Integer[0]);
        return ImmutableEventResponse.of(response.getResponse(), response.getIndex());
    }

    public EventResponse listEvents(String name) {
        return this.listEvents(name, Options.BLANK_QUERY_OPTIONS);
    }

    public EventResponse listEvents(QueryOptions queryOptions) {
        return this.listEvents(null, queryOptions);
    }

    public EventResponse listEvents() {
        return this.listEvents(null, Options.BLANK_QUERY_OPTIONS);
    }

    public void listEvents(String name, QueryOptions queryOptions, EventResponseCallback callback) {
        Map<String, Object> query = queryOptions.toQuery();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            query.put("name", name);
        }
        this.http.extractConsulResponse(this.api.listEvents(query), this.createConsulResponseCallbackWrapper(callback), new Integer[0]);
    }

    private ConsulResponseCallback<List<Event>> createConsulResponseCallbackWrapper(final EventResponseCallback callback) {
        return new ConsulResponseCallback<List<Event>>(){

            @Override
            public void onComplete(ConsulResponse<List<Event>> response) {
                callback.onComplete(ImmutableEventResponse.of(response.getResponse(), response.getIndex()));
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
    }

    public void listEvents(QueryOptions queryOptions, EventResponseCallback callback) {
        this.listEvents(null, queryOptions, callback);
    }

    public void listEvents(EventResponseCallback callback) {
        this.listEvents(null, Options.BLANK_QUERY_OPTIONS, callback);
    }

    static interface Api {
        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @Body RequestBody var2, @QueryMap Map<String, Object> var3);

        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="event/list")
        public Call<List<Event>> listEvents(@QueryMap Map<String, Object> var1);
    }
}

