/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/runtime/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@Api(value="/runtime/{depUnitId}", description="Runtime (Process) operations")
public interface RuntimeResource {
    @GET
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/")
    @ApiOperation(value="Get process definition information", produces="application/xml, application/json", position=0)
    public Response getProcessDefinitionInfo(@PathParam(value="processDefId") String var1);

    @POST
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response startProcessInstance(@PathParam(value="processDefId") String var1);

    @GET
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/startform")
    public Response getProcessInstanceStartForm(@PathParam(value="processDefId") String var1);

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public Response getProcessInstance(@PathParam(value="procInstId") Long var1);

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    public Response abortProcessInstance(@PathParam(value="procInstId") Long var1);

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    public Response signalProcessInstance(@PathParam(value="procInstId") Long var1);

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}/variable/{varName: [\\w\\.-]+}")
    public Response getProcessInstanceVariableByProcInstIdByVarName(@PathParam(value="procInstId") Long var1, @PathParam(value="varName") String var2);

    @POST
    @Path(value="/signal")
    public Response signalProcessInstances();

    @GET
    @Path(value="/workitem/{workItemId: [0-9-]+}")
    public Response getWorkItem(@PathParam(value="workItemId") Long var1);

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public Response doWorkItemOperation(@PathParam(value="workItemId") Long var1, @PathParam(value="oper") String var2);

    @POST
    @Path(value="/withvars/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response withVarsStartProcessInstance(@PathParam(value="processDefId") String var1);

    @GET
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}")
    public Response withVarsGetProcessInstance(@PathParam(value="procInstId") Long var1);

    @POST
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}/signal")
    public Response withVarsSignalProcessInstance(@PathParam(value="procInstId") Long var1);
}

