/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import org.acme.travels.VisaApplication;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.kogito.monitoring.core.common.MonitoringRegistry;
import org.kie.kogito.monitoring.prometheus.common.PrometheusRegistryProvider;
import org.kie.kogito.monitoring.prometheus.common.process.PrometheusProcessEventListener;

public class VisaApplicationPrometheusProcessEventListener
extends PrometheusProcessEventListener {
    private static final String NUMBER_OF_VISA_APPROVED_COUNTER_NAME = "acme_travels_visas_approved_total";
    private static final String NUMBER_OF_VISA_REJECTED_COUNTER_NAME = "acme_travels_visas_rejected_total";
    private String identifier;

    private static Counter getNumberOfVisaApplicationsApprovedCounter(String appId, String country, String duration, String nationality) {
        return Counter.builder((String)NUMBER_OF_VISA_APPROVED_COUNTER_NAME).description("Approved visa applications").tags(Arrays.asList(Tag.of((String)"app_id", (String)appId), Tag.of((String)"country", (String)country), Tag.of((String)"duration", (String)duration), Tag.of((String)"nationality", (String)nationality))).register((MeterRegistry)MonitoringRegistry.getDefaultMeterRegistry());
    }

    private static Counter getNumberOfVisaApplicationsRejected(String appId, String country, String duration, String nationality) {
        return Counter.builder((String)NUMBER_OF_VISA_REJECTED_COUNTER_NAME).description("Rejected visa applications").tags(Arrays.asList(Tag.of((String)"app_id", (String)appId), Tag.of((String)"country", (String)country), Tag.of((String)"duration", (String)duration), Tag.of((String)"nationality", (String)nationality))).register((MeterRegistry)MonitoringRegistry.getDefaultMeterRegistry());
    }

    public VisaApplicationPrometheusProcessEventListener(String identifier) {
        super(identifier);
        this.identifier = identifier;
    }

    public void cleanup() {
        PrometheusRegistryProvider.getPrometheusMeterRegistry().find(NUMBER_OF_VISA_APPROVED_COUNTER_NAME).counters().forEach(x -> MonitoringRegistry.getDefaultMeterRegistry().remove((Meter)x));
        PrometheusRegistryProvider.getPrometheusMeterRegistry().find(NUMBER_OF_VISA_REJECTED_COUNTER_NAME).counters().forEach(x -> MonitoringRegistry.getDefaultMeterRegistry().remove((Meter)x));
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        super.afterProcessCompleted(event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        if (processInstance.getProcessId().equals("visaApplications")) {
            VisaApplication application = (VisaApplication)processInstance.getVariable("visaApplication");
            if (application.isApproved()) {
                VisaApplicationPrometheusProcessEventListener.getNumberOfVisaApplicationsApprovedCounter(this.identifier, this.safeValue(application.getCountry()), String.valueOf(application.getDuration()), this.safeValue(application.getNationality())).increment();
            } else {
                VisaApplicationPrometheusProcessEventListener.getNumberOfVisaApplicationsRejected(this.identifier, this.safeValue(application.getCountry()), String.valueOf(application.getDuration()), this.safeValue(application.getNationality())).increment();
            }
        }
    }

    protected String safeValue(String value) {
        if (value == null) {
            return "unknown";
        }
        return value;
    }
}

