/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.task.management.service;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.WorkItemNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.task.management.service.TaskInfo;
import org.kie.kogito.task.management.service.TaskManagementOperations;
import org.kie.kogito.uow.UnitOfWorkManager;

public class TaskManagementService
implements TaskManagementOperations {
    private Processes processes;
    private ProcessConfig processConfig;

    public TaskManagementService(Processes processes, ProcessConfig processConfig) {
        this.processes = processes;
        this.processConfig = processConfig;
    }

    @Override
    public TaskInfo updateTask(String processId, String processInstanceId, String taskId, TaskInfo taskInfo, boolean shouldReplace, Policy<?> ... policies) {
        ProcessInstance<?> pi = this.getProcessInstance(processId, processInstanceId, taskId);
        KogitoWorkItem workItem = (KogitoWorkItem)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.processConfig.unitOfWorkManager(), () -> (KogitoWorkItem)pi.updateWorkItem(taskId, wi -> {
            if (wi instanceof HumanTaskWorkItemImpl) {
                HumanTaskWorkItemImpl humanTask = (HumanTaskWorkItemImpl)wi;
                this.setField(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setAdminGroups(arg_0), taskInfo::getAdminGroups, shouldReplace);
                this.setField(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setAdminUsers(arg_0), taskInfo::getAdminUsers, shouldReplace);
                this.setField(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setExcludedUsers(arg_0), taskInfo::getExcludedUsers, shouldReplace);
                this.setField(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setPotentialUsers(arg_0), taskInfo::getPotentialUsers, shouldReplace);
                this.setField(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setPotentialGroups(arg_0), taskInfo::getPotentialGroups, shouldReplace);
                this.setField(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setTaskPriority(arg_0), taskInfo::getPriority, shouldReplace);
                this.setField(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setTaskDescription(arg_0), taskInfo::getDescription, shouldReplace);
                this.setMap(arg_0 -> ((HumanTaskWorkItemImpl)humanTask).setParameters(arg_0), (arg_0, arg_1) -> ((HumanTaskWorkItemImpl)humanTask).setParameter(arg_0, arg_1), taskInfo.getInputParams(), shouldReplace);
                return wi;
            }
            throw new IllegalArgumentException("Work item " + taskId + " is not a human task");
        }, policies));
        return this.convert((HumanTaskWorkItem)workItem);
    }

    private void setMap(Consumer<Map<String, Object>> allConsumer, BiConsumer<String, Object> entryConsumer, Map<String, Object> params, boolean shouldReplace) {
        if (params != null) {
            if (shouldReplace) {
                allConsumer.accept(params);
            } else {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    entryConsumer.accept(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private <T> boolean setField(Consumer<T> consumer, Supplier<T> supplier, boolean shouldReplace) {
        boolean result;
        T value = supplier.get();
        boolean bl = result = shouldReplace || value != null;
        if (result) {
            consumer.accept(value);
        }
        return result;
    }

    @Override
    public TaskInfo getTask(String processId, String processInstanceId, String taskId, Policy<?> ... policies) {
        return this.getProcessInstance(processId, processInstanceId, taskId).findNodes(ni -> this.isSearchWorkItem((KogitoNodeInstance)ni, taskId, policies)).stream().findFirst().map(this::convert).orElseThrow(() -> new WorkItemNotFoundException(taskId));
    }

    private boolean isSearchWorkItem(KogitoNodeInstance ni, String taskId, Policy<?> ... policies) {
        return ni instanceof WorkItemNodeInstance && ((WorkItemNodeInstance)ni).getWorkItemId().equals(taskId) && ((WorkItemNodeInstance)ni).getWorkItem().enforce(policies) && ((WorkItemNodeInstance)ni).getWorkItem() instanceof HumanTaskWorkItem;
    }

    private TaskInfo convert(KogitoNodeInstance wi) {
        return this.convert((HumanTaskWorkItem)((WorkItemNodeInstance)wi).getWorkItem());
    }

    private TaskInfo convert(HumanTaskWorkItem humanTask) {
        return new TaskInfo(humanTask.getTaskDescription(), humanTask.getTaskPriority(), humanTask.getPotentialUsers(), humanTask.getPotentialGroups(), humanTask.getExcludedUsers(), humanTask.getAdminUsers(), humanTask.getAdminGroups(), humanTask.getParameters());
    }

    private ProcessInstance<?> getProcessInstance(String processId, String processInstanceId, String taskId) {
        if (processId == null) {
            throw new IllegalArgumentException("Process id must be given");
        }
        if (processInstanceId == null) {
            throw new IllegalArgumentException("Process instance id must be given");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Task id must be given");
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            throw new IllegalArgumentException(String.format("Process with id %s not found", processId));
        }
        return (ProcessInstance)process.instances().findById(processInstanceId).orElseThrow(() -> new ProcessInstanceNotFoundException(processInstanceId));
    }
}

