/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sw.onboarding.services;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.acme.sw.onboarding.model.Appointment;
import org.acme.sw.onboarding.model.Patient;

@ApplicationScoped
public class ScheduleService {
    public static final int FIRST_HOUR_MORNING = 9;
    private final Map<String, List<LocalDateTime>> schedule = new ConcurrentHashMap<String, List<LocalDateTime>>();

    public Appointment createAppointment(Patient patient) {
        Appointment appointment = new Appointment();
        String doctorId = patient.getAssignedDoctor().getId();
        appointment.setPatient(patient);
        appointment.setDate(LocalDateTime.now().plusHours(1L));
        appointment.setDoctor(patient.getAssignedDoctor());
        if (this.schedule.get(doctorId) != null) {
            Optional lastDate = this.schedule.get(doctorId).stream().max(Comparator.nullsFirst(Comparator.naturalOrder()));
            appointment.setDate(this.addOneDayFirstHourInMorning((LocalDateTime)lastDate.orElseThrow(IllegalStateException::new)));
        } else {
            this.schedule.put(doctorId, new ArrayList());
        }
        this.schedule.get(doctorId).add(appointment.getDate());
        return appointment;
    }

    private LocalDateTime addOneDayFirstHourInMorning(LocalDateTime targetDate) {
        return targetDate.plusDays(1L).withHour(9).withMinute(0);
    }
}

