/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sw.onboarding.resources;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.acme.sw.onboarding.model.Appointment;
import org.acme.sw.onboarding.model.Error;
import org.acme.sw.onboarding.model.Patient;
import org.acme.sw.onboarding.services.ScheduleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/onboarding/schedule/appointment")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AppointmentResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppointmentResource.class);
    private final List<Appointment> appointments = new ArrayList<Appointment>();
    @Inject
    ScheduleService scheduleService;

    @POST
    public Response schedulePatientAppointment(@NotNull Patient patient) {
        LOGGER.debug("Receive patient to schedule appointments: {}", (Object)patient);
        if (patient.getId() == null || patient.getId().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Error("Patient has not been processed! Patients need to have an ID.")).build();
        }
        if (patient.getAssignedDoctor() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Error("Doctor has not been assigned! Impossible to schedule an appointment. Please assign a doctor first.")).build();
        }
        this.appointments.add(this.scheduleService.createAppointment(patient));
        LOGGER.debug("Processed patient: {}", (Object)patient);
        return Response.ok((Object)patient).build();
    }

    @GET
    public List<Appointment> getAppointmentCalendar() {
        return this.appointments;
    }

    @GET
    @Path(value="/doctor/{id}")
    public List<Appointment> getScheduleForDoctor(@NotEmpty @PathParam(value="id") String doctorId) {
        return this.appointments.stream().filter(a -> a.getDoctor().getId().equals(doctorId)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/patient/{id}")
    public List<Appointment> getScheduleForPatient(@NotEmpty @PathParam(value="id") String patientId) {
        return this.appointments.stream().filter(a -> a.getPatient().getId().equals(patientId) && a.getDate().isAfter(LocalDateTime.now())).collect(Collectors.toList());
    }
}

