/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.drools.core.util.IoUtils;
import org.infinispan.protostream.BaseMarshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.kogito.persistence.protobuf.ProtoStreamObjectMarshallingStrategy;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.process.impl.marshalling.ProcessInstanceMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreProcessInstances
implements MutableProcessInstances {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreProcessInstances.class);
    private final Process<?> process;
    private final PgPool client;
    private final ProcessInstanceMarshaller marshaller;
    private final boolean autoDDL;
    private final Long queryTimeoutMillis;

    public PostgreProcessInstances(Process<?> process, PgPool client, boolean autoDDL, Long queryTimeoutMillis, String proto, BaseMarshaller<?> ... marshallers) {
        this.process = process;
        this.client = client;
        this.autoDDL = autoDDL;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.marshaller = new ProcessInstanceMarshaller(new ObjectMarshallingStrategy[]{new ProtoStreamObjectMarshallingStrategy(proto, marshallers)});
        this.init();
    }

    public boolean exists(String id) {
        return this.findById(id).isPresent();
    }

    public void create(String id, ProcessInstance instance) {
        this.insertInternal(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
        this.disconnect(instance);
    }

    public void update(String id, ProcessInstance instance) {
        this.updateInternal(UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
        this.disconnect(instance);
    }

    public void remove(String id) {
        this.deleteInternal(UUID.fromString(id));
    }

    public Optional<ProcessInstance> findById(String id, ProcessInstanceReadMode mode) {
        return this.findByIdInternal(UUID.fromString(id)).map(b -> this.marshaller.unmarshallProcessInstance(b, this.process));
    }

    public Collection<ProcessInstance> values(ProcessInstanceReadMode mode) {
        return this.findAllInternal().stream().map(i -> this.marshaller.unmarshallProcessInstance(i, this.process)).collect(Collectors.toList());
    }

    public Integer size() {
        return this.countInternal().intValue();
    }

    private void disconnect(ProcessInstance instance) {
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(() -> {
            try {
                byte[] reloaded = this.findByIdInternal(UUID.fromString(instance.id())).get();
                return this.marshaller.unmarshallWorkflowProcessInstance(reloaded, this.process);
            }
            catch (RuntimeException e) {
                LOGGER.error("Unexpected exception thrown when reloading process instance {}", (Object)instance.id(), (Object)e);
                return null;
            }
        });
    }

    private boolean insertInternal(UUID id, byte[] payload) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("INSERT INTO process_instances (id, payload, process_id) VALUES ($1, $2, $3)").execute(Tuple.of((Object)id, (Object)Buffer.buffer((byte[])payload), (Object)this.process.id()), this.getAsyncResultHandler(future));
            return this.getExecutedResult(future);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
    }

    private RuntimeException uncheckedException(Exception ex, String message, Object ... param) {
        return new RuntimeException(String.format(message, param), ex);
    }

    private Handler<AsyncResult<RowSet<Row>>> getAsyncResultHandler(CompletableFuture<RowSet<Row>> future) {
        return ar -> {
            if (ar.succeeded()) {
                future.complete((RowSet)ar.result());
            } else {
                future.completeExceptionally(ar.cause());
            }
        };
    }

    private boolean updateInternal(UUID id, byte[] payload) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("UPDATE process_instances SET payload = $1 WHERE id = $2)").execute(Tuple.of((Object)Buffer.buffer((byte[])payload), (Object)id), this.getAsyncResultHandler(future));
            return this.getExecutedResult(future);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
    }

    private boolean deleteInternal(UUID id) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("DELETE FROM process_instances WHERE id = $1").execute(Tuple.of((Object)id), this.getAsyncResultHandler(future));
            return this.getExecutedResult(future);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
    }

    private Boolean getExecutedResult(CompletableFuture<RowSet<Row>> future) throws ExecutionException, TimeoutException, InterruptedException {
        return this.getResultFromFuture(future).map(SqlResult::rowCount).map(count -> Objects.equals(count, 1)).orElse(false);
    }

    private Optional<RowSet<Row>> getResultFromFuture(CompletableFuture<RowSet<Row>> future) throws ExecutionException, TimeoutException, InterruptedException {
        try {
            return Optional.ofNullable(future.get(this.queryTimeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private Optional<byte[]> findByIdInternal(UUID id) {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("SELECT payload FROM process_instances WHERE id = $1").execute(Tuple.of((Object)id), this.getAsyncResultHandler(future));
            return this.getResultFromFuture(future).map(RowSet::iterator).filter(Iterator::hasNext).map(Iterator::next).map(row -> row.getBuffer("payload")).map(Buffer::getBytes);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
    }

    private List<byte[]> findAllInternal() {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("SELECT payload FROM process_instances WHERE process_id = $1").execute(Tuple.of((Object)this.process.id()), this.getAsyncResultHandler(future));
            return this.getResultFromFuture(future).map(r -> StreamSupport.stream(r.spliterator(), false).map(row -> row.getBuffer("payload")).map(Buffer::getBytes).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", this.process.id());
        }
    }

    private Long countInternal() {
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.preparedQuery("SELECT COUNT(id) FROM process_instances WHERE process_id = $1").execute(Tuple.of((Object)this.process.id()), this.getAsyncResultHandler(future));
            return this.getResultFromFuture(future).map(RowSet::iterator).map(RowIterator::next).map(row -> row.getLong("count")).orElse(0L);
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error counting process instances, for processId %s", this.process.id());
        }
    }

    private void init() {
        if (!this.autoDDL) {
            LOGGER.debug("Auto DDL is disabled, do not running initializer scripts");
            return;
        }
        try {
            CompletableFuture<RowSet<Row>> future = new CompletableFuture<RowSet<Row>>();
            this.client.query(this.getQueryFromFile("exists_tables")).execute(this.getAsyncResultHandler(future));
            CompletionStage futureCompose = future.thenCompose(rows -> {
                CompletableFuture futureCreate = new CompletableFuture();
                return Optional.ofNullable(rows.iterator()).filter(Iterator::hasNext).map(Iterator::next).map(row -> row.getBoolean("exists")).filter(Boolean.FALSE::equals).map(e -> this.client.query(this.getQueryFromFile("create_tables"))).map(q -> {
                    q.execute(this.getAsyncResultHandler(futureCreate));
                    LOGGER.info("Creating process_instances table.");
                    return futureCreate;
                }).orElseGet(() -> {
                    futureCreate.complete(null);
                    LOGGER.info("Table process_instances already exists.");
                    return futureCreate;
                });
            });
            this.getResultFromFuture((CompletableFuture<RowSet<Row>>)futureCompose).map(SqlResult::rowCount).ifPresent(count -> {
                if (count > 0) {
                    LOGGER.info("DDL successfully done for ProcessInstance");
                } else {
                    LOGGER.info("DDL executed with no changes for ProcessInstance");
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error creating process_instances table, the database should be configured properly before starting the application", (Throwable)e);
        }
    }

    private String getQueryFromFile(String scriptName) {
        try {
            return new String(IoUtils.readBytesFromInputStream((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("sql/%s.sql", scriptName))));
        }
        catch (IOException e) {
            throw this.uncheckedException(e, "Error reading query script file %s", scriptName);
        }
    }
}

