/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Type;
import org.kie.kogito.persistence.postgresql.hibernate.JsonBinaryType;
import org.kie.kogito.persistence.postgresql.model.CacheId;

@Entity
@IdClass(value=CacheId.class)
@Table(name="kogito_data_cache", uniqueConstraints={@UniqueConstraint(columnNames={"name", "key"})}, indexes={@Index(columnList="name,key", unique=true)})
public class CacheEntity {
    @Id
    @Column(nullable=false)
    private String name;
    @Id
    @Column(nullable=false)
    private String key;
    @Type(value=JsonBinaryType.class)
    @Column(name="json_value", columnDefinition="jsonb")
    private ObjectNode value;

    public CacheEntity() {
    }

    public CacheEntity(String name, String key) {
        this.name = name;
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ObjectNode getValue() {
        return this.value;
    }

    public void setValue(ObjectNode value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheEntity)) {
            return false;
        }
        CacheEntity that = (CacheEntity)o;
        return this.getName().equals(that.getName()) && this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getKey());
    }

    public String toString() {
        return "CacheEntity{name='" + this.name + "', key='" + this.key + "', value=" + this.value + "}";
    }
}

