/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.hibernate;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class JsonBinaryType
implements UserType<JsonNode> {
    private ObjectMapper mapper = new ObjectMapper();

    public int getSqlType() {
        return 2000;
    }

    public Class<JsonNode> returnedClass() {
        return JsonNode.class;
    }

    public boolean equals(JsonNode x, JsonNode y) {
        return Objects.equals(x, y);
    }

    public int hashCode(JsonNode x) {
        return Objects.hashCode(x);
    }

    public JsonNode nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        String json = rs.getString(position);
        if (json == null) {
            return null;
        }
        try {
            return this.mapper.readTree(json.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to convert String to JSON: " + ex.getMessage(), ex);
        }
    }

    public void nullSafeSet(PreparedStatement ps, JsonNode value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            ps.setNull(index, 1111);
            return;
        }
        try {
            ps.setObject(index, (Object)value.toString(), 1111);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to convert JSON to String: %s", ex.getMessage()), ex);
        }
    }

    public JsonNode deepCopy(JsonNode value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return value.deepCopy();
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(JsonNode value) throws HibernateException {
        return this.deepCopy(value).toString();
    }

    public JsonNode assemble(Serializable cached, Object owner) throws HibernateException {
        try {
            return this.mapper.readTree(cached.toString());
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(String.format("Failed to convert String to JSON: %s", ex.getMessage()), ex);
        }
    }

    public JsonNode replace(JsonNode original, JsonNode target, Object owner) throws HibernateException {
        return original;
    }
}

