/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.properties.IfBuildProperty;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.postgresql.PostgresStorage;
import org.kie.kogito.persistence.postgresql.model.CacheEntityRepository;

@ApplicationScoped
@IfBuildProperty(name="kogito.apps.persistence.type", stringValue="postgresql")
public class PostgresStorageService
implements StorageService {
    @Inject
    protected CacheEntityRepository repository;
    @Inject
    protected ObjectMapper mapper;

    public Storage<String, String> getCache(String name) {
        return new PostgresStorage<String>(name, this.repository, this.mapper, String.class);
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        return new PostgresStorage<T>(name, this.repository, this.mapper, type);
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        return new PostgresStorage<T>(name, this.repository, this.mapper, type, rootType);
    }
}

