/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.CustomType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.FilterCondition;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.postgresql.hibernate.JsonBinaryType;
import org.kie.kogito.persistence.postgresql.model.CacheEntityRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresQuery<T>
implements Query<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresQuery.class);
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String ATTRIBUTE_ACCESSOR = "(json_value->>'%s')";
    private final String name;
    private final CacheEntityRepository repository;
    private final ObjectMapper objectMapper;
    private final Class<T> type;
    private Integer limit;
    private Integer offset;
    private List<AttributeFilter<?>> filters;
    private List<AttributeSort> sortBy;
    private Map<String, JsonField> fields;

    public PostgresQuery(String name, CacheEntityRepository repository, ObjectMapper objectMapper, Class<T> type) {
        this.name = name;
        this.repository = repository;
        this.objectMapper = objectMapper;
        this.type = type;
    }

    public Query<T> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query<T> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Query<T> filter(List<AttributeFilter<?>> filters) {
        this.filters = filters;
        return this;
    }

    public Query<T> sort(List<AttributeSort> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public List<T> execute() {
        this.fields = this.addFilters(new HashMap<String, JsonField>(), this.filters);
        if (this.sortBy != null && !this.sortBy.isEmpty()) {
            this.sortBy.stream().filter((? super T sortBy) -> !this.fields.containsKey(sortBy.getAttribute())).forEach(sortBy -> this.fields.put(sortBy.getAttribute(), new JsonField(sortBy.getAttribute())));
        }
        StringBuilder queryString = new StringBuilder("SELECT * FROM kogito_data_cache").append(" WHERE name = '").append(this.name).append("'");
        if (this.filters != null && !this.filters.isEmpty()) {
            queryString.append(AND);
            queryString.append(this.filters.stream().map(filter -> new StringBuilder().append(this.filterStringFunction((AttributeFilter<?>)filter))).collect(Collectors.joining(AND)));
        }
        if (this.sortBy != null && !this.sortBy.isEmpty()) {
            queryString.append(" ORDER BY ");
            queryString.append(this.sortBy.stream().map(f -> {
                JsonField field = this.fields.get(f.getAttribute());
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, f.getAttribute())).append(" ").append(f.getSort().name());
            }).collect(Collectors.joining(", ")));
        }
        LOGGER.debug("Executing PostgreSQL query: {}", (Object)queryString);
        jakarta.persistence.Query query = this.repository.getEntityManager().createNativeQuery(queryString.toString());
        ((NativeQuery)query.unwrap(NativeQuery.class)).addScalar("json_value", (BasicDomainType)new CustomType((UserType)new JsonBinaryType(), new TypeConfiguration()));
        if (this.limit != null) {
            query.setMaxResults(this.limit.intValue());
        }
        if (this.offset != null) {
            query.setFirstResult(this.offset.intValue());
        }
        List results = query.getResultList();
        return results.stream().map(r -> {
            if (r == null) {
                return null;
            }
            try {
                return this.objectMapper.readValue(this.objectMapper.writeValueAsString(r), this.type);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private Map<String, JsonField> addFilters(Map<String, JsonField> fields, List<AttributeFilter<?>> filters) {
        if (Objects.isNull(filters) || filters.isEmpty()) {
            return fields;
        }
        filters.stream().filter((? super T filter) -> Objects.nonNull(filter.getAttribute())).filter((? super T filter) -> !Objects.equals(filter.getCondition(), FilterCondition.NOT)).filter((? super T filter) -> !Objects.equals(filter.getCondition(), FilterCondition.AND)).filter((? super T filter) -> !Objects.equals(filter.getCondition(), FilterCondition.OR)).filter((? super T filter) -> !Objects.equals(filter.getCondition(), FilterCondition.BETWEEN)).filter((? super T filter) -> !fields.containsKey(filter.getAttribute())).forEach(filter -> fields.put(filter.getAttribute(), new JsonField(filter.getAttribute(), filter.getValue())));
        this.addFilters(fields, filters.stream().filter((? super T filter) -> Objects.equals(filter.getCondition(), FilterCondition.NOT)).map(filter -> (AttributeFilter)filter.getValue()).collect(Collectors.toList()));
        this.addFilters(fields, filters.stream().filter((? super T filter) -> Objects.equals(filter.getCondition(), FilterCondition.AND)).map(filter -> (List)filter.getValue()).flatMap(Collection::stream).collect(Collectors.toList()));
        this.addFilters(fields, filters.stream().filter((? super T filter) -> Objects.equals(filter.getCondition(), FilterCondition.OR)).map(filter -> (List)filter.getValue()).flatMap(Collection::stream).collect(Collectors.toList()));
        filters.stream().filter((? super T filter) -> Objects.equals(filter.getCondition(), FilterCondition.BETWEEN)).filter((? super T filter) -> !fields.containsKey(filter.getAttribute())).forEach(filter -> fields.put(filter.getAttribute(), new JsonField(filter.getAttribute(), ((List)filter.getValue()).get(0))));
        return fields;
    }

    private String filterStringFunction(AttributeFilter<?> filter) {
        JsonField field = this.fields.get(filter.getAttribute());
        switch (filter.getCondition()) {
            case CONTAINS: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("= %s", PostgresQuery.getValueForQueryString(filter.getValue()))).toString();
            }
            case CONTAINS_ALL: {
                return ((List)filter.getValue()).stream().map(o -> PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("= %s", PostgresQuery.getValueForQueryString(o)))).collect(Collectors.joining(AND));
            }
            case CONTAINS_ANY: {
                return ((List)filter.getValue()).stream().map(o -> PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("= %s", PostgresQuery.getValueForQueryString(o)))).collect(Collectors.joining(OR));
            }
            case LIKE: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("LIKE %s", PostgresQuery.getValueForQueryString(filter.getValue()))).toString().replaceAll("\\*", "%");
            }
            case EQUAL: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("= %s", PostgresQuery.getValueForQueryString(filter.getValue()))).toString();
            }
            case IN: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("IN (%s)", ((List)filter.getValue()).stream().map(PostgresQuery::getValueForQueryString).collect(Collectors.joining(", ")))).toString();
            }
            case IS_NULL: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append("IS NULL").toString();
            }
            case NOT_NULL: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append("IS NOT NULL").toString();
            }
            case BETWEEN: {
                List value = (List)filter.getValue();
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("BETWEEN %s AND %s", PostgresQuery.getValueForQueryString(value.get(0)), PostgresQuery.getValueForQueryString(value.get(1)))).toString();
            }
            case GT: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("> %s", PostgresQuery.getValueForQueryString(filter.getValue()))).toString();
            }
            case GTE: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format(">= %s", PostgresQuery.getValueForQueryString(filter.getValue()))).toString();
            }
            case LT: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("< %s", PostgresQuery.getValueForQueryString(filter.getValue()))).toString();
            }
            case LTE: {
                return PostgresQuery.cast(field, String.format(ATTRIBUTE_ACCESSOR, filter.getAttribute())).append(String.format("<= %s", PostgresQuery.getValueForQueryString(filter.getValue()))).toString();
            }
            case OR: {
                return this.getRecursiveString(filter, OR);
            }
            case AND: {
                return this.getRecursiveString(filter, AND);
            }
            case NOT: {
                return String.format("not %s", this.filterStringFunction((AttributeFilter)filter.getValue()));
            }
        }
        return null;
    }

    private static StringBuilder cast(JsonField field, String accessor) {
        StringBuilder cast = new StringBuilder();
        Object value = field.value;
        if (value instanceof Number) {
            cast.append("(").append(accessor).append(")\\:\\:numeric ");
        } else {
            cast.append(accessor).append(" ");
        }
        return cast;
    }

    private static String getValueForQueryString(Object value) {
        return value instanceof String ? "'" + value + "'" : value.toString();
    }

    private String getRecursiveString(AttributeFilter<?> filter, String joining) {
        return ((List)filter.getValue()).stream().map(this::filterStringFunction).collect(Collectors.joining(joining, "(", ")"));
    }

    private static final class JsonField {
        String name;
        Object value;

        JsonField(String name) {
            this(name, null);
        }

        JsonField(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

