/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mgmt;

import io.quarkus.qute.Template;
import io.quarkus.qute.api.ResourcePath;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VertxRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRouter.class);
    @ResourcePath(value="index")
    Template indexTemplate;
    private String index;

    @PostConstruct
    public void init() {
        this.index = this.indexTemplate.render();
    }

    void setupRouter(@Observes Router router) {
        router.route("/").handler(ctx -> ctx.response().putHeader("location", "/ProcessInstances/").setStatusCode(302).end());
        router.route("/Process*").handler(ctx -> this.handle((RoutingContext)ctx));
        router.route("/DomainExplorer*").handler(ctx -> this.handle((RoutingContext)ctx));
        router.route().handler((Handler)StaticHandler.create());
    }

    public void handle(RoutingContext context) {
        try {
            context.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html;charset=utf8").end(this.index);
        }
        catch (Exception ex) {
            LOGGER.error("Error handling index.html", (Throwable)ex);
            context.fail(500, (Throwable)ex);
        }
    }
}

