/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mgmt;

import io.quarkus.vertx.web.Route;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.StandardCharsets;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VertxRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRouter.class);
    @Inject
    @ConfigProperty(name="kogito.dataindex.http.url", defaultValue="http://localhost:8180")
    String dataIndexHttpURL;
    @Inject
    Vertx vertx;
    private String resource;

    @PostConstruct
    public void init() {
        this.resource = this.vertx.fileSystem().readFileBlocking("META-INF/resources/index.html").toString(StandardCharsets.UTF_8).replace("__DATA_INDEX_ENDPOINT__", "\"" + this.dataIndexHttpURL + "/graphql\"");
    }

    @Route(path="/", methods={HttpMethod.GET})
    public void handle(RoutingContext context) {
        try {
            context.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html;charset=utf8").end(this.resource);
        }
        catch (Exception ex) {
            LOGGER.error("Error handling index.html", (Throwable)ex);
            context.fail(500, (Throwable)ex);
        }
    }
}

