/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.timer.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.kie.kogito.timer.Calendar;
import org.kie.kogito.timer.Calendars;
import org.kie.kogito.timer.Trigger;

public class PointInTimeTrigger
implements Trigger {
    private Date timestamp;

    public PointInTimeTrigger() {
    }

    public PointInTimeTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        boolean included = true;
        if (calendars != null && calendarNames != null && calendarNames.length > 0) {
            for (String calName : calendarNames) {
                Calendar cal = calendars.get(calName);
                if (cal == null || cal.isTimeIncluded(timestamp)) continue;
                included = false;
                break;
            }
        }
        if (included) {
            this.timestamp = new Date(timestamp);
        }
    }

    @Override
    public Date hasNextFireTime() {
        return this.timestamp;
    }

    @Override
    public Date nextFireTime() {
        Date next = this.timestamp;
        this.timestamp = null;
        return next;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timestamp = (Date)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.timestamp);
    }

    public String toString() {
        return "PointInTimeTrigger @ " + this.timestamp;
    }
}

