/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.mapper.BaseObjectMapper;
import io.serverlessworkflow.api.mapper.JsonObjectMapper;
import io.serverlessworkflow.api.mapper.YamlObjectMapper;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerlessWorkflowUtils {
    public static final String DEFAULT_WORKFLOW_FORMAT = "json";
    public static final String ALTERNATE_WORKFLOW_FORMAT = "yml";
    public static final String APP_PROPERTIES_BASE = "kogito.sw.";
    private static final String APP_PROPERTIES_FUNCTIONS_BASE = "functions.";
    public static final String APP_PROPERTIES_STATES_BASE = "states.";
    public static final String OPENAPI_OPERATION_SEPARATOR = "#";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerlessWorkflowUtils.class);

    private ServerlessWorkflowUtils() {
    }

    public static BaseObjectMapper getObjectMapper(String workflowFormat) {
        return ALTERNATE_WORKFLOW_FORMAT.equals(workflowFormat) ? new YamlObjectMapper() : new JsonObjectMapper();
    }

    public static String conditionScript(String conditionStr) {
        if (conditionStr.startsWith("{{")) {
            conditionStr = conditionStr.substring(2);
        }
        if (conditionStr.endsWith("}}")) {
            conditionStr = conditionStr.substring(0, conditionStr.length() - 2);
        }
        return conditionStr.trim();
    }

    public static String resolveFunctionMetadata(FunctionDefinition function, String metadataKey, KogitoBuildContext context) {
        return ServerlessWorkflowUtils.resolveFunctionMetadata(function, metadataKey, context, "");
    }

    public static Integer resolveFunctionMetadataAsInt(FunctionDefinition function, String metadataKey, KogitoBuildContext context) {
        String value = ServerlessWorkflowUtils.resolveFunctionMetadata(function, metadataKey, context);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Error converting {} to number", (Object)value, (Object)ex);
            return null;
        }
    }

    public static String resolveFunctionMetadata(FunctionDefinition function, String metadataKey, KogitoBuildContext context, String defaultValue) {
        if (function != null && function.getMetadata() != null && function.getMetadata().containsKey(metadataKey)) {
            return (String)function.getMetadata().get(metadataKey);
        }
        if (function != null && context != null && context.getApplicationProperties().contains("kogito.sw.functions." + function.getName() + "." + metadataKey)) {
            return (String)context.getApplicationProperty("kogito.sw.functions." + function.getName() + "." + metadataKey).get();
        }
        LOGGER.warn("Could not resolve function metadata: {}", (Object)metadataKey);
        return defaultValue;
    }

    public static String getOpenApiURI(FunctionDefinition function) {
        if (ServerlessWorkflowUtils.isOpenApiOperation(function)) {
            return function.getOperation().substring(0, function.getOperation().indexOf(OPENAPI_OPERATION_SEPARATOR));
        }
        return "";
    }

    public static String getOpenApiOperationId(FunctionDefinition function) {
        String uri = ServerlessWorkflowUtils.getOpenApiURI(function);
        if (uri.isEmpty()) {
            return "";
        }
        return function.getOperation().substring(uri.length() + 1);
    }

    public static boolean isOpenApiOperation(FunctionDefinition function) {
        return function.getType() == FunctionDefinition.Type.REST && function.getOperation() != null && function.getOperation().contains(OPENAPI_OPERATION_SEPARATOR);
    }
}

