"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var process_details_1 = require("@kogito-apps/process-details");
var ProcessDetailsContext_1 = require("../../../channel/ProcessDetails/ProcessDetailsContext");
var react_router_dom_1 = require("react-router-dom");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var ProcessDetailsContainer = function (_a) {
    var processInstance = _a.processInstance, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var history = (0, react_router_dom_1.useHistory)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    var gatewayApi = (0, ProcessDetailsContext_1.useProcessDetailsGatewayApi)();
    (0, react_1.useEffect)(function () {
        var unSubscribeHandler = gatewayApi.onOpenProcessInstanceDetailsListener({
            onOpen: function (id) {
                history.push("/");
                history.push("/Process/".concat(id));
            }
        });
        return function () {
            unSubscribeHandler.unSubscribe();
        };
    }, [processInstance]);
    return ((0, jsx_runtime_1.jsx)(process_details_1.EmbeddedProcessDetails, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'process-details-container', ouiaSafe), { driver: gatewayApi, targetOrigin: appContext.getDevUIUrl(), processInstance: processInstance, omittedProcessTimelineEvents: appContext.omittedProcessTimelineEvents, diagramPreviewSize: appContext.diagramPreviewSize, showSwfDiagram: appContext.isWorkflow(), isStunnerEnabled: appContext.getIsStunnerEnabled(), singularProcessLabel: appContext.customLabels.singularProcessLabel, pluralProcessLabel: appContext.customLabels.pluralProcessLabel })));
};
exports.default = ProcessDetailsContainer;
//# sourceMappingURL=ProcessDetailsContainer.js.map