"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var forms_list_1 = require("@kogito-apps/forms-list");
var FormsListContext_1 = require("../../../channel/FormsList/FormsListContext");
var react_router_dom_1 = require("react-router-dom");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var FormsListContainer = function () {
    var history = (0, react_router_dom_1.useHistory)();
    var gatewayApi = (0, FormsListContext_1.useFormsListGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    (0, react_1.useEffect)(function () {
        var unsubscriber = gatewayApi.onOpenFormListen({
            onOpen: function (formData) {
                history.push({
                    pathname: "/Forms/".concat(formData.name),
                    state: {
                        filter: gatewayApi.getFormFilter(),
                        formData: formData
                    }
                });
            }
        });
        return function () {
            unsubscriber.unSubscribe();
        };
    }, []);
    return ((0, jsx_runtime_1.jsx)(forms_list_1.EmbeddedFormsList, { driver: gatewayApi, targetOrigin: appContext.getDevUIUrl() }));
};
exports.default = FormsListContainer;
//# sourceMappingURL=FormsListContainer.js.map