"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var custom_dashboard_view_1 = require("@kogito-apps/custom-dashboard-view");
var CustomDashboardViewContext_1 = require("../../../channel/CustomDashboardView/CustomDashboardViewContext");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var CustomDashboardViewContainer = function (_a) {
    var dashboardName = _a.dashboardName, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var gatewayApi = (0, CustomDashboardViewContext_1.useCustomDashboardViewGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    return ((0, jsx_runtime_1.jsx)(custom_dashboard_view_1.EmbeddedCustomDashboardView, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'process-details-container', ouiaSafe), { driver: gatewayApi, targetOrigin: appContext.getDevUIUrl(), dashboardName: dashboardName })));
};
exports.default = CustomDashboardViewContainer;
//# sourceMappingURL=CustomDashboardViewContainer.js.map