"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var CloudEventForm_1 = require("../../../channel/CloudEventForm");
var embedded_1 = require("@kogito-apps/cloud-event-form/dist/embedded");
var react_router_1 = require("react-router");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var CloudEventFormContainer = function (_a) {
    var isTriggerNewInstance = _a.isTriggerNewInstance, onSuccess = _a.onSuccess, onError = _a.onError, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var gatewayApi = (0, CloudEventForm_1.useCloudEventFormGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    var instanceId = (0, react_router_1.useParams)().instanceId;
    var triggerStartCloudEvent = (0, react_1.useCallback)(function (event) {
        return gatewayApi
            .triggerStartCloudEvent(event)
            .then(function (businessKey) {
            onSuccess("A workflow with business key ".concat(businessKey, " has been successfully triggered."));
        })
            .catch(function (error) { return handleError(error); });
    }, [gatewayApi, onSuccess, onError]);
    var triggerCloudEvent = (0, react_1.useCallback)(function (event) {
        return gatewayApi
            .triggerCloudEvent(event)
            .then(function (response) {
            console.log(response);
            onSuccess('The CloudEvent has been successfully triggered.');
        })
            .catch(function (error) { return handleError(error); });
    }, [gatewayApi, onSuccess, onError]);
    var handleError = (0, react_1.useCallback)(function (error) {
        var message = (error === null || error === void 0 ? void 0 : error.message) ||
            'Unknown error. More details in the developer tools console.';
        onError(message);
    }, [gatewayApi, onSuccess, onError]);
    return ((0, jsx_runtime_1.jsx)(embedded_1.EmbeddedCloudEventForm, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'cloud-event-form-container', ouiaSafe), { targetOrigin: appContext.getDevUIUrl(), isNewInstanceEvent: isTriggerNewInstance, defaultValues: {
            cloudEventSource: '/local/quarkus-devUi',
            instanceId: instanceId !== null && instanceId !== void 0 ? instanceId : undefined
        }, driver: {
            triggerCloudEvent: function (event) {
                var doTrigger = isTriggerNewInstance
                    ? triggerStartCloudEvent
                    : triggerCloudEvent;
                return doTrigger(event);
            }
        } })));
};
exports.default = CloudEventFormContainer;
//# sourceMappingURL=CloudEventFormContainer.js.map