"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessDetailsGatewayApiImpl = void 0;
var ProcessDetailsGatewayApiImpl = (function () {
    function ProcessDetailsGatewayApiImpl(queries) {
        var _this = this;
        this.listeners = [];
        this.getProcessDiagram = function (data) { return __awaiter(_this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.queries.getSVG(data)];
                    case 1:
                        result = _a.sent();
                        return [2, Promise.resolve(result)];
                }
            });
        }); };
        this.handleProcessAbort = function (processInstance) {
            return _this.queries.handleProcessAbort(processInstance);
        };
        this.cancelJob = function (job) {
            return _this.queries.jobCancel(job);
        };
        this.rescheduleJob = function (job, repeatInterval, repeatLimit, scheduleDate) {
            return _this.queries.rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
        };
        this.handleProcessVariableUpdate = function (processInstance, updatedJson) {
            return _this.queries.handleProcessVariableUpdate(processInstance, updatedJson);
        };
        this.queries = queries;
        this._ProcessDetailsState = { id: '' };
    }
    Object.defineProperty(ProcessDetailsGatewayApiImpl.prototype, "processDetailsState", {
        get: function () {
            return this._ProcessDetailsState;
        },
        enumerable: false,
        configurable: true
    });
    ProcessDetailsGatewayApiImpl.prototype.getTriggerableNodes = function (processInstance) {
        return this.queries.getTriggerableNodes(processInstance);
    };
    ProcessDetailsGatewayApiImpl.prototype.handleNodeTrigger = function (processInstance, node) {
        return this.queries.handleNodeTrigger(processInstance, node);
    };
    ProcessDetailsGatewayApiImpl.prototype.processDetailsQuery = function (id) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.queries
                .getProcessDetails(id)
                .then(function (value) {
                resolve(value);
            })
                .catch(function (reason) {
                reject(reason);
            });
        });
    };
    ProcessDetailsGatewayApiImpl.prototype.jobsQuery = function (id) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.queries
                .getJobs(id)
                .then(function (value) {
                resolve(value);
            })
                .catch(function (reason) {
                reject(reason);
            });
        });
    };
    ProcessDetailsGatewayApiImpl.prototype.openProcessInstanceDetails = function (id) {
        this._ProcessDetailsState = { id: id };
        this.listeners.forEach(function (listener) { return listener.onOpen(id); });
        return Promise.resolve();
    };
    ProcessDetailsGatewayApiImpl.prototype.onOpenProcessInstanceDetailsListener = function (listener) {
        var _this = this;
        this.listeners.push(listener);
        var unSubscribe = function () {
            var index = _this.listeners.indexOf(listener);
            if (index > -1) {
                _this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    ProcessDetailsGatewayApiImpl.prototype.handleProcessRetry = function (processInstance) {
        return this.queries.handleProcessRetry(processInstance);
    };
    ProcessDetailsGatewayApiImpl.prototype.handleNodeInstanceCancel = function (processInstance, node) {
        return this.queries.handleNodeInstanceCancel(processInstance, node);
    };
    ProcessDetailsGatewayApiImpl.prototype.handleProcessSkip = function (processInstance) {
        return this.queries.handleProcessSkip(processInstance);
    };
    ProcessDetailsGatewayApiImpl.prototype.handleNodeInstanceRetrigger = function (processInstance, node) {
        return this.queries.handleNodeInstanceRetrigger(processInstance, node);
    };
    return ProcessDetailsGatewayApiImpl;
}());
exports.ProcessDetailsGatewayApiImpl = ProcessDetailsGatewayApiImpl;
//# sourceMappingURL=ProcessDetailsGatewayApi.js.map