"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessDefinitionListGatewayApiImpl = void 0;
var apis_1 = require("../apis");
var ProcessDefinitionListGatewayApiImpl = (function () {
    function ProcessDefinitionListGatewayApiImpl(url, path) {
        this.onOpenProcessListeners = [];
        this.onOpenTriggerCloudEventListeners = [];
        this.processDefinitonFilter = [];
        this.devUIUrl = url;
        this.openApiPath = path;
    }
    ProcessDefinitionListGatewayApiImpl.prototype.getProcessDefinitionFilter = function () {
        return Promise.resolve(this.processDefinitonFilter);
    };
    ProcessDefinitionListGatewayApiImpl.prototype.setProcessDefinitionFilter = function (filter) {
        this.processDefinitonFilter = filter;
        return Promise.resolve();
    };
    ProcessDefinitionListGatewayApiImpl.prototype.openProcessForm = function (processDefinition) {
        this.onOpenProcessListeners.forEach(function (listener) {
            return listener.onOpen(processDefinition);
        });
        return Promise.resolve();
    };
    ProcessDefinitionListGatewayApiImpl.prototype.onOpenProcessFormListen = function (listener) {
        var _this = this;
        this.onOpenProcessListeners.push(listener);
        var unSubscribe = function () {
            var index = _this.onOpenProcessListeners.indexOf(listener);
            if (index > -1) {
                _this.onOpenProcessListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    ProcessDefinitionListGatewayApiImpl.prototype.onOpenTriggerCloudEventListen = function (listener) {
        var _this = this;
        this.onOpenTriggerCloudEventListeners.push(listener);
        var unSubscribe = function () {
            var index = _this.onOpenTriggerCloudEventListeners.indexOf(listener);
            if (index > -1) {
                _this.onOpenTriggerCloudEventListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    ProcessDefinitionListGatewayApiImpl.prototype.getProcessDefinitionsQuery = function () {
        return (0, apis_1.getProcessDefinitionList)(this.devUIUrl, this.openApiPath);
    };
    ProcessDefinitionListGatewayApiImpl.prototype.openTriggerCloudEvent = function () {
        this.onOpenTriggerCloudEventListeners.forEach(function (listener) {
            return listener.onOpen();
        });
    };
    return ProcessDefinitionListGatewayApiImpl;
}());
exports.ProcessDefinitionListGatewayApiImpl = ProcessDefinitionListGatewayApiImpl;
//# sourceMappingURL=ProcessDefinitionListGatewayApi.js.map