import { ProcessDefinition } from '@kogito-apps/process-definition-list';
export interface ProcessDefinitionListGatewayApi {
    getProcessDefinitionFilter: () => Promise<string[]>;
    setProcessDefinitionFilter: (filter: string[]) => Promise<void>;
    getProcessDefinitionsQuery: () => Promise<ProcessDefinition[]>;
    openProcessForm: (processDefinition: ProcessDefinition) => Promise<void>;
    openTriggerCloudEvent: () => void;
    onOpenProcessFormListen: (listener: OnOpenProcessFormListener) => UnSubscribeHandler;
    onOpenTriggerCloudEventListen: (listener: OnOpenTriggerCloudEventListener) => UnSubscribeHandler;
}
export interface OnOpenProcessFormListener {
    onOpen: (processDefinition: ProcessDefinition) => void;
}
export interface OnOpenTriggerCloudEventListener {
    onOpen: () => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class ProcessDefinitionListGatewayApiImpl implements ProcessDefinitionListGatewayApi {
    private readonly onOpenProcessListeners;
    private readonly onOpenTriggerCloudEventListeners;
    private readonly devUIUrl;
    private readonly openApiPath;
    private processDefinitonFilter;
    constructor(url: string, path: string);
    getProcessDefinitionFilter(): Promise<string[]>;
    setProcessDefinitionFilter(filter: string[]): Promise<void>;
    openProcessForm(processDefinition: ProcessDefinition): Promise<void>;
    onOpenProcessFormListen(listener: OnOpenProcessFormListener): UnSubscribeHandler;
    onOpenTriggerCloudEventListen(listener: OnOpenTriggerCloudEventListener): UnSubscribeHandler;
    getProcessDefinitionsQuery(): Promise<ProcessDefinition[]>;
    openTriggerCloudEvent(): void;
}
