"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormsListGatewayApiImpl = void 0;
var apis_1 = require("../apis");
var FormsListGatewayApiImpl = (function () {
    function FormsListGatewayApiImpl() {
        var _this = this;
        this._FormFilter = {
            formNames: []
        };
        this.listeners = [];
        this.getFormFilter = function () {
            return Promise.resolve(_this._FormFilter);
        };
        this.applyFilter = function (formFilter) {
            _this._FormFilter = formFilter;
            return Promise.resolve();
        };
        this.openForm = function (formData) {
            _this.listeners.forEach(function (listener) { return listener.onOpen(formData); });
            return Promise.resolve();
        };
    }
    FormsListGatewayApiImpl.prototype.getFormsQuery = function () {
        return (0, apis_1.getForms)(this._FormFilter.formNames);
    };
    FormsListGatewayApiImpl.prototype.onOpenFormListen = function (listener) {
        var _this = this;
        this.listeners.push(listener);
        var unSubscribe = function () {
            var index = _this.listeners.indexOf(listener);
            if (index > -1) {
                _this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    return FormsListGatewayApiImpl;
}());
exports.FormsListGatewayApiImpl = FormsListGatewayApiImpl;
//# sourceMappingURL=FormsListGatewayApi.js.map