import { FormFilter, FormInfo } from '@kogito-apps/forms-list';
export interface FormsListGatewayApi {
    getFormFilter(): Promise<FormFilter>;
    applyFilter(formList: FormFilter): Promise<void>;
    getFormsQuery(): Promise<FormInfo[]>;
    openForm: (formData: FormInfo) => Promise<void>;
    onOpenFormListen: (listener: OnOpenFormListener) => UnSubscribeHandler;
}
export interface OnOpenFormListener {
    onOpen: (formData: FormInfo) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class FormsListGatewayApiImpl implements FormsListGatewayApi {
    private _FormFilter;
    private readonly listeners;
    getFormFilter: () => Promise<FormFilter>;
    applyFilter: (formFilter: FormFilter) => Promise<void>;
    getFormsQuery(): Promise<FormInfo[]>;
    openForm: (formData: FormInfo) => Promise<void>;
    onOpenFormListen(listener: OnOpenFormListener): UnSubscribeHandler;
}
